/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Window;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.util.Static;

public final class GUIUtilities
extends Static {
    private GUIUtilities() {
    }

    public static Window getWindow(ObservableValue<?> observableValue) {
        if (observableValue instanceof ObjectProperty) {
            ContextMenu contextMenu;
            Object object = ((ObjectProperty)observableValue).getBean();
            if (object instanceof Node) {
                Scene scene = ((Node)object).getScene();
                if (scene != null) {
                    return scene.getWindow();
                }
            } else if (object instanceof MenuItem && (contextMenu = ((MenuItem)object).getParentPopup()) != null) {
                while (true) {
                    Window window;
                    if (!((window = contextMenu.getOwnerWindow()) instanceof ContextMenu)) {
                        return window;
                    }
                    contextMenu = (ContextMenu)window;
                }
            }
        }
        return null;
    }

    public static void setClipToBounds(Pane pane) {
        Rectangle rectangle = new Rectangle();
        rectangle.widthProperty().bind((ObservableValue)pane.widthProperty());
        rectangle.heightProperty().bind((ObservableValue)pane.heightProperty());
        pane.setClip((Node)rectangle);
    }

    public static <E> boolean copyAsDiff(List<? extends E> list, ObservableList<E> observableList) {
        if (list.isEmpty()) {
            boolean bl = observableList.isEmpty();
            observableList.clear();
            return !bl;
        }
        if (observableList.isEmpty()) {
            return observableList.setAll(list);
        }
        List<E> list2 = GUIUtilities.longestCommonSubsequence(list, observableList);
        boolean bl = false;
        int n = observableList.size();
        int n2 = list2.size();
        while (--n2 >= 0) {
            E e = list2.get(n2);
            int n3 = n;
            while (observableList.get(--n3) != e) {
            }
            if (n3 + 1 < n) {
                observableList.remove(n3 + 1, n);
                bl = true;
            }
            n = n3;
        }
        if (n != 0) {
            observableList.remove(0, n);
            bl = true;
        }
        assert (list2.equals(observableList));
        n2 = 0;
        for (int i = 0; i < observableList.size(); ++i) {
            Object object = observableList.get(i);
            n = n2;
            while (list.get(n) != object) {
                ++n;
            }
            if (n2 < n) {
                observableList.addAll(i, list.subList(n2, n));
                i += n - n2;
                bl = true;
            }
            n2 = n + 1;
        }
        n = list.size();
        if (n2 < n) {
            observableList.addAll(list.subList(n2, n));
            bl = true;
        }
        assert (list.equals(observableList));
        return bl;
    }

    static <E> List<? extends E> longestCommonSubsequence(List<? extends E> list, List<? extends E> list2) {
        E e;
        List<Object> list3;
        int n;
        int n2;
        List<Object> list4;
        List<E> list5 = list;
        List<E> list6 = list2;
        int n3 = list.size();
        int n4 = list2.size();
        int n5 = 0;
        while (true) {
            if (n5 >= n3) {
                return list;
            }
            if (n5 >= n4) {
                return list2;
            }
            if (list.get(n5) != list2.get(n5)) {
                if (n5 == 0) {
                    list4 = Collections.emptyList();
                    break;
                }
                list4 = list.subList(0, n5);
                assert (list2.subList(0, n5).equals(list4));
                list = list.subList(n5, n3);
                list2 = list2.subList(n5, n4);
                n3 -= n5;
                n4 -= n5;
                break;
            }
            ++n5;
        }
        int n6 = 0;
        while (true) {
            n2 = n3 - n6;
            n = n4 - n6;
            if (n2 == 0) {
                return list5;
            }
            if (n == 0) {
                return list6;
            }
            if (list.get(n2 - 1) != list2.get(n - 1)) {
                if (n6 == 0) {
                    list3 = Collections.emptyList();
                    break;
                }
                list3 = list.subList(n2, n3);
                assert (list2.subList(n, n4).equals(list3));
                list = list.subList(0, n2);
                list2 = list2.subList(0, n);
                n3 -= n6;
                n4 -= n6;
                break;
            }
            ++n6;
        }
        int[][] nArray = new int[n3 + 1][n4 + 1];
        for (n2 = 1; n2 <= n3; ++n2) {
            n = n2 - 1;
            e = list.get(n);
            for (int i = 1; i <= n4; ++i) {
                int n7 = i - 1;
                nArray[n2][i] = list2.get(n7) == e ? Math.incrementExact(nArray[n][n7]) : Math.max(nArray[n2][n7], nArray[n][i]);
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(nArray[n3][n4] + list4.size() + list3.size());
        while (n3 > 0 && n4 > 0) {
            n = nArray[n3][n4];
            if (nArray[n3 - 1][n4] >= n) {
                --n3;
                continue;
            }
            if (nArray[n3][--n4] >= n) continue;
            e = list.get(--n3);
            assert (e == list2.get(n4));
            arrayList.add(e);
        }
        Collections.reverse(arrayList);
        arrayList.addAll(0, list4);
        arrayList.addAll(list3);
        return arrayList;
    }

    public static Quantity<Length> shorter(Quantity<Length> quantity, double d) {
        Unit<Length> unit = d < 1.0 ? Units.CENTIMETRE : (d < 1000.0 ? Units.METRE : Units.KILOMETRE);
        if (quantity != null && unit.equals((Object)quantity.getUnit())) {
            return quantity;
        }
        d = Units.METRE.getConverterTo(unit).convert(Math.max(d, 0.01));
        return Quantities.create(d, unit);
    }

    public static Color fromARGB(int n) {
        return Color.rgb((int)(0xFF & n >>> 16), (int)(0xFF & n >>> 8), (int)(0xFF & n));
    }

    public static int toARGB(Color color) {
        return GUIUtilities.toByte(color.getOpacity()) << 24 | GUIUtilities.toByte(color.getRed()) << 16 | GUIUtilities.toByte(color.getGreen()) << 8 | GUIUtilities.toByte(color.getBlue());
    }

    private static int toByte(double d) {
        return (int)Math.round(d * 255.0);
    }
}

