/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Window;
import org.apache.sis.gui.Widget;
import org.apache.sis.internal.gui.ResourceLoader;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.util.Classes;

public final class ExceptionReporter
extends Widget {
    private static final Insets MARGIN = new Insets(9.0, 3.0, 3.0, 9.0);
    private static final Insets PADDING = new Insets(9.0, 3.0, 1.0, 3.0);
    private static Alert currentlyShown;
    private Throwable exception;
    private final VBox view;
    private final Text trace;

    public ExceptionReporter(Throwable throwable) {
        this.exception = throwable;
        this.trace = new Text(ExceptionReporter.getStackTrace(throwable));
        ScrollPane scrollPane = new ScrollPane((Node)this.trace);
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        scrollPane.setPadding(MARGIN);
        Resources resources = Resources.getInstance();
        Menu menu = new Menu(resources.getString((short)31));
        menu.getItems().add((Object)resources.menu((short)32, (EventHandler<ActionEvent>)((EventHandler)this::printStackTrace)));
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{resources.menu((short)11, (EventHandler<ActionEvent>)((EventHandler)this::copy)), menu});
        scrollPane.setContextMenu(contextMenu);
        Label label = new Label(resources.getString((short)53));
        this.view = new VBox(new Node[]{label, scrollPane});
        VBox.setVgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
        VBox.setMargin((Node)scrollPane, (Insets)PADDING);
        VBox.setMargin((Node)label, (Insets)PADDING);
        this.view.setPrefHeight(400.0);
    }

    public void setException(Throwable throwable) {
        this.trace.setText(ExceptionReporter.getStackTrace(throwable));
        this.exception = throwable;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    @Override
    public final Region getView() {
        return this.view;
    }

    private static Window getWindow(Node node) {
        Scene scene;
        if (node != null && (scene = node.getScene()) != null) {
            return scene.getWindow();
        }
        return null;
    }

    public static void show(Node node, WorkerStateEvent workerStateEvent) {
        Worker worker = workerStateEvent.getSource();
        Throwable throwable = worker.getException();
        if (worker instanceof ResourceLoader) {
            ExceptionReporter.canNotReadFile(node, ((ResourceLoader)worker).getFileName(), throwable);
        } else {
            ExceptionReporter.show(ExceptionReporter.getWindow(node), (short)0, (short)0, null, throwable);
        }
    }

    public static void canNotReadFile(Node node, String string, Throwable throwable) {
        ExceptionReporter.show(ExceptionReporter.getWindow(node), (short)19, (short)6, new Object[]{string}, throwable);
    }

    public static void canNotCloseFile(Node node, String string, Throwable throwable) {
        ExceptionReporter.show(ExceptionReporter.getWindow(node), (short)14, (short)2, new Object[]{string}, throwable);
    }

    public static void canNotCreateCRS(Window window, String string, Throwable throwable) {
        ExceptionReporter.show(window, (short)15, (short)3, new Object[]{string}, throwable);
    }

    public static void canNotUseResource(Node node, Throwable throwable) {
        ExceptionReporter.show(ExceptionReporter.getWindow(node), (short)16, (short)16, new Object[0], throwable);
    }

    private static void show(Window window, short s, short s2, Object[] objectArray, Throwable throwable) {
        if (throwable != null) {
            String string = null;
            String string2 = null;
            if ((s | s2) != 0) {
                Resources resources = Resources.getInstance();
                if (s != 0) {
                    string = resources.getString(s);
                }
                if (s2 != 0) {
                    string2 = resources.getString(s2, objectArray);
                }
            }
            ExceptionReporter.show(window, string, string2, throwable);
        }
    }

    public static void show(Node node, String string, String string2, Throwable throwable) {
        ExceptionReporter.show(ExceptionReporter.getWindow(node), string, string2, throwable);
    }

    public static void show(Window window, String string, String string2, Throwable throwable) {
        Alert alert;
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> ExceptionReporter.show(window, string, string2, throwable));
            return;
        }
        String string3 = throwable.getLocalizedMessage();
        if (string3 == null) {
            string3 = Classes.getShortClassName(throwable);
        }
        if ((alert = currentlyShown) == null) {
            alert = new Alert(Alert.AlertType.ERROR);
            alert.initOwner(window);
            alert.setOnHidden(dialogEvent -> {
                currentlyShown = null;
            });
            ExceptionReporter exceptionReporter = new ExceptionReporter(throwable);
            DialogPane dialogPane = alert.getDialogPane();
            dialogPane.setExpandableContent((Node)exceptionReporter.getView());
            dialogPane.setPrefWidth(650.0);
            dialogPane.setUserData((Object)exceptionReporter);
        } else {
            ExceptionReporter exceptionReporter = (ExceptionReporter)alert.getDialogPane().getUserData();
            exceptionReporter.setException(throwable);
        }
        if (string != null) {
            alert.setTitle(string);
        }
        if (string2 != null) {
            alert.setHeaderText(string2);
        }
        alert.setContentText(string3);
        alert.show();
        currentlyShown = alert;
    }

    public static void show(Node node, Task<?> task) {
        ExceptionReporter.show(node, task.getTitle(), null, task.getException());
    }

    private void copy(ActionEvent actionEvent) {
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(this.trace.getText());
        Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
    }

    private void printStackTrace(ActionEvent actionEvent) {
        this.exception.printStackTrace();
    }
}

