/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextArea;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;
import org.apache.sis.gui.referencing.AuthorityCodes;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

final class WKTPane
extends StringConverter<Convention>
implements ChangeListener<Convention> {
    private final WKTFormat format;
    final ChoiceBox<Convention> convention;
    private final EnumMap<Convention, String> conventionTexts;
    final TextArea text = new TextArea();
    private CoordinateReferenceSystem crs;

    WKTPane(Locale locale) {
        Object[] objectArray = new Convention[]{Convention.WKT2_SIMPLIFIED, Convention.WKT2, Convention.WKT1, Convention.WKT1_COMMON_UNITS};
        this.conventionTexts = new EnumMap(Convention.class);
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        for (Convention convention : objectArray) {
            this.conventionTexts.put(convention, this.toString(convention, vocabulary));
        }
        this.format = new WKTFormat(locale, null);
        this.format.setConvention(Convention.WKT2_SIMPLIFIED);
        this.convention = new ChoiceBox(FXCollections.observableArrayList((Object[])objectArray));
        this.convention.setConverter((StringConverter)this);
        this.convention.getSelectionModel().select((Object)this.format.getConvention());
        this.convention.valueProperty().addListener((ChangeListener)this);
        this.convention.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow(this.convention, (Priority)Priority.ALWAYS);
    }

    private String toString(Convention convention, Vocabulary vocabulary) {
        Object object;
        boolean bl = false;
        switch (convention) {
            case WKT2_SIMPLIFIED: {
                bl = true;
            }
            case WKT2: {
                object = 2;
                break;
            }
            case WKT1: {
                object = 1;
                break;
            }
            case WKT1_COMMON_UNITS: {
                object = "GDAL 1-2";
                break;
            }
            default: {
                return convention.name();
            }
        }
        Object object2 = vocabulary.getString((short)218, "WKT (Well Known Text)", object);
        if (bl) {
            object2 = (String)object2 + " \u2014 " + vocabulary.getString((short)180);
        }
        return object2;
    }

    public String toString(Convention convention) {
        return this.conventionTexts.get(convention);
    }

    public Convention fromString(String string) {
        for (Map.Entry<Convention, String> entry : this.conventionTexts.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void changed(ObservableValue<? extends Convention> observableValue, Convention convention, Convention convention2) {
        this.format.setConvention(convention2);
        if (this.crs != null) {
            this.text.setText(this.format.format((Object)this.crs));
        }
    }

    final void setContent(final AuthorityCodes authorityCodes, final String string) {
        this.text.setDisable(true);
        BackgroundThreads.execute((Runnable)new Task<CoordinateReferenceSystem>(){
            private String wkt;

            protected CoordinateReferenceSystem call() throws FactoryException {
                CoordinateReferenceSystem coordinateReferenceSystem = authorityCodes.getFactory().createCoordinateReferenceSystem(string);
                if (coordinateReferenceSystem != null) {
                    this.wkt = WKTPane.this.format.format((Object)coordinateReferenceSystem);
                }
                return coordinateReferenceSystem;
            }

            protected void succeeded() {
                WKTPane.this.setContent((CoordinateReferenceSystem)this.getValue(), this.wkt);
            }

            protected void cancelled() {
                WKTPane.this.text.setText(null);
            }

            protected void failed() {
                WKTPane.this.text.setDisable(false);
                WKTPane.this.text.setEditable(false);
                WKTPane.this.text.setText(Exceptions.getLocalizedMessage(this.getException(), authorityCodes.locale));
            }
        });
    }

    private void setContent(CoordinateReferenceSystem coordinateReferenceSystem, String string) {
        this.text.setEditable(false);
        this.text.setDisable(false);
        if (coordinateReferenceSystem != this.crs) {
            this.crs = coordinateReferenceSystem;
            this.text.setText(string);
        }
    }
}

