/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.function.Predicate;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.TableView;
import org.apache.sis.gui.referencing.AuthorityCodes;
import org.apache.sis.gui.referencing.Code;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.CharSequences;

final class CodeFilter
implements Predicate<Code> {
    private final AuthorityCodes allCodes;
    private final String[] tokens;

    private CodeFilter(AuthorityCodes authorityCodes, String[] stringArray) {
        this.allCodes = authorityCodes;
        this.tokens = stringArray;
    }

    static void apply(TableView<Code> tableView, String string) {
        String[] stringArray;
        FilteredList filteredList;
        AuthorityCodes authorityCodes;
        ObservableList observableList = tableView.getItems();
        if (observableList instanceof AuthorityCodes) {
            authorityCodes = (AuthorityCodes)observableList;
            filteredList = null;
        } else {
            filteredList = (FilteredList)observableList;
            authorityCodes = (AuthorityCodes)filteredList.getSource();
        }
        string = Strings.trimOrNull(string);
        if (string != null && (stringArray = (String[])CharSequences.split(string = string.toLowerCase(authorityCodes.locale), ' ')).length != 0) {
            CodeFilter codeFilter = new CodeFilter(authorityCodes, stringArray);
            if (filteredList == null) {
                filteredList = new FilteredList((ObservableList)authorityCodes, (Predicate)codeFilter);
                tableView.setItems((ObservableList)filteredList);
            } else {
                filteredList.setPredicate((Predicate)codeFilter);
            }
            return;
        }
        tableView.setItems((ObservableList)authorityCodes);
    }

    @Override
    public boolean test(Code code) {
        String string = code.code.toLowerCase(this.allCodes.locale);
        String string2 = this.allCodes.getName(code).getValue();
        string2 = string2 != null ? string2.toLowerCase(this.allCodes.locale) : "";
        for (String string3 : this.tokens) {
            if (string2.contains(string3) || string.equals(string3)) continue;
            return false;
        }
        return true;
    }
}

