/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.Locale;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.Duration;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.gui.referencing.AuthorityCodes;
import org.apache.sis.gui.referencing.Code;
import org.apache.sis.gui.referencing.CodeFilter;
import org.apache.sis.gui.referencing.Utils;
import org.apache.sis.gui.referencing.WKTPane;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.IdentityValueFactory;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class CRSChooser
extends Dialog<CoordinateReferenceSystem> {
    private final BorderPane content;
    private final HBox tools;
    private final TextField searchField;
    private final TableView<Code> table;
    private final GridPane summary;
    private final Label type;
    private final Label domain;
    private final ImmutableEnvelope areaOfInterest;
    private WKTPane wktPane;

    public CRSChooser() {
        this(null, null, null);
    }

    public CRSChooser(CRSAuthorityFactory cRSAuthorityFactory, Envelope envelope, Locale locale) {
        this.areaOfInterest = Utils.toGeographic(CRSChooser.class, "<init>", envelope);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Resources resources = Resources.forLocale(locale);
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        AuthorityCodes authorityCodes = new AuthorityCodes(cRSAuthorityFactory, locale);
        this.table = new TableView((ObservableList)authorityCodes);
        authorityCodes.owner = this.table;
        TableColumn tableColumn = new TableColumn(vocabulary.getString((short)28));
        TableColumn tableColumn2 = new TableColumn(vocabulary.getString((short)139));
        tableColumn2.setCellValueFactory((Callback)authorityCodes);
        tableColumn.setCellValueFactory(IdentityValueFactory.instance());
        tableColumn.setCellFactory(Code.Cell::new);
        tableColumn.setMinWidth(60.0);
        tableColumn.setMaxWidth(120.0);
        this.table.setPrefWidth(500.0);
        this.table.getColumns().setAll((Object[])new TableColumn[]{tableColumn, tableColumn2});
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        Label label = new Label("\u23f3");
        label.setFont(Font.font((double)30.0));
        this.table.setPlaceholder((Node)label);
        this.searchField = new TextField();
        this.searchField.setOnAction(actionEvent -> CodeFilter.apply(this.table, this.searchField.getText()));
        HBox.setHgrow((Node)this.searchField, (Priority)Priority.ALWAYS);
        Label label2 = new Label(vocabulary.getString((short)84));
        label2.setLabelFor((Node)this.searchField);
        ToggleButton toggleButton = new ToggleButton("\ud83d\uddb9");
        this.table.getSelectionModel().selectedItemProperty().addListener((observableValue, code, code2) -> {
            toggleButton.setDisable(code2 == null);
            this.updateSummary((Code)code2);
        });
        toggleButton.setOnAction(actionEvent -> this.setTools(toggleButton.isSelected()));
        toggleButton.setDisable(true);
        this.tools = new HBox(new Node[]{label2, this.searchField, toggleButton});
        this.tools.setSpacing(9.0);
        this.tools.setAlignment(Pos.BASELINE_LEFT);
        BorderPane.setMargin((Node)this.tools, (Insets)new Insets(0.0, 0.0, 9.0, 0.0));
        label2 = new Label(vocabulary.getLabel((short)203));
        toggleButton = new Label(vocabulary.getLabel((short)69));
        this.type = new Label();
        label2.setLabelFor((Node)this.type);
        this.domain = new Label();
        toggleButton.setLabelFor((Node)this.domain);
        this.summary = Styles.createControlGrid(0, new Label[]{label2, toggleButton});
        Tooltip tooltip = new Tooltip();
        tooltip.setShowDelay(Duration.seconds((double)0.5));
        tooltip.setShowDuration(Duration.minutes((double)1.0));
        tooltip.maxWidthProperty().bind((ObservableValue)this.summary.widthProperty());
        tooltip.setWrapText(true);
        this.domain.setTooltip(tooltip);
        label2 = this.getDialogPane();
        this.content = new BorderPane();
        this.content.setCenter(this.table);
        this.content.setTop((Node)this.tools);
        this.content.setBottom((Node)this.summary);
        label2.setContent((Node)this.content);
        label2.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.setTitle(resources.getString((short)30));
        this.setResultConverter(this::getSelectedCRS);
        this.setResizable(true);
    }

    private void setTools(boolean bl) {
        GridPane gridPane;
        TextArea textArea;
        ChoiceBox<Convention> choiceBox;
        short s;
        Locale locale = this.getAuthorityCodes().locale;
        if (bl) {
            if (this.wktPane == null) {
                this.wktPane = new WKTPane(locale);
            }
            this.wktPane.setContent(this.getAuthorityCodes(), ((Code)this.table.getSelectionModel().getSelectedItem()).code);
            s = 85;
            choiceBox = this.wktPane.convention;
            textArea = this.wktPane.text;
            gridPane = null;
        } else {
            s = 84;
            choiceBox = this.searchField;
            textArea = this.table;
            gridPane = this.summary;
        }
        ObservableList observableList = this.tools.getChildren();
        Label label = (Label)observableList.get(0);
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        label.setText(vocabulary.getLabel(s));
        label.setLabelFor(choiceBox);
        observableList.set(1, choiceBox);
        this.content.setCenter((Node)textArea);
        this.content.setBottom((Node)gridPane);
    }

    private AuthorityCodes getAuthorityCodes() {
        ObservableList observableList = this.table.getItems();
        if (observableList instanceof FilteredList) {
            observableList = ((FilteredList)observableList).getSource();
        }
        return (AuthorityCodes)observableList;
    }

    private void updateSummary(Code code) {
        if (code == null) {
            this.clearSummary();
            return;
        }
        final AuthorityCodes authorityCodes = this.getAuthorityCodes();
        final String string = code.code;
        BackgroundThreads.execute((Runnable)new Task<CoordinateReferenceSystem>(){

            protected CoordinateReferenceSystem call() throws FactoryException {
                return authorityCodes.getFactory().createCoordinateReferenceSystem(string);
            }

            protected void succeeded() {
                CoordinateReferenceSystem coordinateReferenceSystem = (CoordinateReferenceSystem)this.getValue();
                CRSChooser.this.type.setTextFill((Paint)Styles.NORMAL_TEXT);
                CRSChooser.this.type.setText(CRSChooser.typeOf(coordinateReferenceSystem, authorityCodes.locale));
                CRSChooser.this.setDomainOfValidity(coordinateReferenceSystem.getDomainOfValidity(), authorityCodes.locale);
            }

            protected void cancelled() {
                CRSChooser.this.clearSummary();
            }

            protected void failed() {
                this.cancelled();
                CRSChooser.this.type.setTextFill((Paint)Styles.ERROR_TEXT);
                CRSChooser.this.type.setText(Exceptions.getLocalizedMessage(this.getException(), authorityCodes.locale));
            }
        });
    }

    private void clearSummary() {
        this.type.setText(null);
        this.domain.setText(null);
    }

    private void setDomainOfValidity(Extent extent, Locale locale) {
        Object object = Extents.getDescription((Extent)extent, (Locale)locale);
        String string = object;
        Color color = Styles.NORMAL_TEXT;
        if (!Utils.intersects(this.areaOfInterest, extent)) {
            string = Resources.forLocale(locale).getString((short)13);
            object = "\u26a0\ufe0f " + (String)(object != null ? object : string);
            color = Styles.ERROR_TEXT;
        }
        this.domain.setTextFill((Paint)color);
        this.domain.setText((String)object);
        this.domain.getTooltip().setText(string);
    }

    private static String typeOf(CoordinateReferenceSystem coordinateReferenceSystem, Locale locale) {
        int n;
        int n2;
        while (coordinateReferenceSystem instanceof CompoundCRS) {
            coordinateReferenceSystem = (CoordinateReferenceSystem)((CompoundCRS)coordinateReferenceSystem).getComponents().get(0);
        }
        if (coordinateReferenceSystem instanceof GeographicCRS) {
            n2 = 92;
            n = 2;
        } else if (coordinateReferenceSystem instanceof GeocentricCRS) {
            n2 = 86;
            n = 3;
        } else if (coordinateReferenceSystem instanceof GeodeticCRS) {
            n2 = 90;
            n = 0;
        } else if (coordinateReferenceSystem instanceof VerticalCRS) {
            n2 = 220;
            n = 1;
        } else if (coordinateReferenceSystem instanceof TemporalCRS) {
            n2 = 191;
            n = 1;
        } else if (coordinateReferenceSystem instanceof ProjectedCRS) {
            n2 = 162;
            n = 2;
        } else if (coordinateReferenceSystem instanceof EngineeringCRS) {
            n2 = 77;
            n = 0;
        } else {
            n2 = 207;
            n = 0;
        }
        String string = Vocabulary.getResources(locale).getString((short)n2);
        int n3 = ReferencingUtilities.getDimension((CoordinateReferenceSystem)coordinateReferenceSystem);
        boolean bl = n3 != n && n != 0;
        boolean bl2 = coordinateReferenceSystem instanceof GeneralDerivedCRS;
        if (bl | bl2) {
            String string2;
            OperationMethod operationMethod;
            Conversion conversion;
            StringBuilder stringBuilder = new StringBuilder(string);
            if (bl) {
                stringBuilder.append(" (").append(n3).append("D)");
            }
            if (bl2 && (conversion = ((GeneralDerivedCRS)coordinateReferenceSystem).getConversionFromBase()) != null && (operationMethod = conversion.getMethod()) != null && (string2 = IdentifiedObjects.getDisplayName((IdentifiedObject)operationMethod, (Locale)locale)) != null) {
                stringBuilder.append(" \u2014 ").append(string2);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    private CoordinateReferenceSystem getSelectedCRS(ButtonType buttonType) {
        Code code;
        if (ButtonType.OK.equals(buttonType) && (code = (Code)this.table.getSelectionModel().getSelectedItem()) != null) {
            try {
                return this.getAuthorityCodes().getFactory().createCoordinateReferenceSystem(code.code);
            }
            catch (FactoryException factoryException) {
                ExceptionReporter.canNotCreateCRS(this.getOwner(), code.code, factoryException);
            }
        }
        return null;
    }

    public Optional<CoordinateReferenceSystem> showDialog(Window window) {
        this.initOwner(window);
        return this.showAndWait();
    }
}

