/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableListBase;
import javafx.concurrent.Task;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import org.apache.sis.gui.referencing.Code;
import org.apache.sis.gui.referencing.Utils;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

final class AuthorityCodes
extends ObservableListBase<Code>
implements Callback<TableColumn.CellDataFeatures<Code, String>, ObservableValue<String>> {
    private static final long REFRESH_DELAY = 100000000L;
    TableView<Code> owner;
    private static final Class<? extends IdentifiedObject> type = CoordinateReferenceSystem.class;
    private final List<Object> codes;
    private int describedCount;
    final Locale locale;
    private CRSAuthorityFactory factory;
    private Loader loader;
    private volatile boolean hasError;

    AuthorityCodes(CRSAuthorityFactory cRSAuthorityFactory, Locale locale) {
        this.locale = locale;
        this.factory = cRSAuthorityFactory;
        this.codes = new ArrayList<Object>();
        this.loader = new Loader();
        this.loader.start();
    }

    final synchronized CRSAuthorityFactory getFactory() throws FactoryException {
        if (this.factory == null) {
            this.factory = Utils.getDefaultFactory();
        }
        return this.factory;
    }

    public int size() {
        return this.codes.size();
    }

    public Code get(int n) {
        Object object = this.codes.get(n);
        if (object instanceof Code) {
            return (Code)object;
        }
        Code code = new Code((String)object);
        this.codes.set(n, code);
        return code;
    }

    public boolean add(Code code) {
        int n = this.codes.size();
        this.codes.add(code);
        this.beginChange();
        this.nextAdd(n, n + 1);
        this.endChange();
        return true;
    }

    public ObservableValue<String> call(TableColumn.CellDataFeatures<Code, String> cellDataFeatures) {
        return this.getName((Code)cellDataFeatures.getValue()).getReadOnlyProperty();
    }

    final ReadOnlyStringWrapper getName(Code code) {
        ReadOnlyStringWrapper readOnlyStringWrapper = code.name();
        String string = readOnlyStringWrapper.getValue();
        if (string == null) {
            this.loader.requestName(code);
        }
        return readOnlyStringWrapper;
    }

    private void update(PartialResult partialResult) {
        assert (Platform.isFxApplicationThread());
        int n = this.codes.size();
        if (partialResult.codes != null) {
            this.codes.addAll(Arrays.asList(partialResult.codes));
        }
        this.beginChange();
        this.nextAdd(n, this.codes.size());
        if (partialResult.names != null) {
            ListIterator<Object> listIterator = this.codes.listIterator();
            while (listIterator.hasNext()) {
                Object object = listIterator.next();
                String string = partialResult.names.remove(object);
                if (string == null) continue;
                int n2 = listIterator.previousIndex();
                if (string.isEmpty()) {
                    listIterator.remove();
                    this.nextRemove(n2, (Code)object);
                    continue;
                }
                ((Code)object).name().set(string);
                ++this.describedCount;
                this.nextUpdate(n2);
            }
        }
        this.endChange();
        if (this.describedCount >= this.codes.size()) {
            this.removeHourglass();
        }
    }

    private void removeHourglass() {
        if (this.owner != null) {
            this.owner.setPlaceholder(null);
            this.owner = null;
        }
    }

    private void errorOccurred(Throwable throwable) {
        if (!this.hasError) {
            this.hasError = true;
            Logging.unexpectedException(Logging.getLogger("org.apache.sis.gui"), AuthorityCodes.class, "get", throwable);
        }
    }

    private final class Loader
    extends Task<PartialResult> {
        private final List<Code> toDescribe;
        private final boolean loadCodes;
        private boolean isRunning;

        Loader() {
            this.toDescribe = new ArrayList<Code>();
            this.loadCodes = true;
        }

        private Loader(Loader loader) {
            this.toDescribe = loader.toDescribe;
            this.loadCodes = false;
        }

        final void start() {
            this.isRunning = true;
            BackgroundThreads.execute((Runnable)((Object)this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void requestName(Code code) {
            assert (Platform.isFxApplicationThread());
            List<Code> list = this.toDescribe;
            synchronized (list) {
                this.toDescribe.add(code);
            }
            if (!this.isRunning) {
                this.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Code, String> processNameRequests(CRSAuthorityFactory cRSAuthorityFactory) {
            Code[] codeArray;
            Object object = this.toDescribe;
            synchronized (object) {
                int n = this.toDescribe.size();
                if (n == 0) {
                    return null;
                }
                codeArray = this.toDescribe.toArray(new Code[n]);
                this.toDescribe.clear();
            }
            object = new IdentityHashMap(codeArray.length);
            for (Code code : codeArray) {
                String string;
                try {
                    string = Strings.trimOrNull(Types.toString((InternationalString)cRSAuthorityFactory.getDescriptionText(code.code), (Locale)AuthorityCodes.this.locale));
                    if (string == null) {
                        string = Vocabulary.getResources(AuthorityCodes.this.locale).getString((short)208);
                    }
                }
                catch (FactoryException factoryException) {
                    AuthorityCodes.this.errorOccurred(factoryException);
                    string = "";
                }
                object.put(code, string);
            }
            return object;
        }

        protected PartialResult call() throws Exception {
            long l = System.nanoTime();
            List list = Collections.emptyList();
            CRSAuthorityFactory cRSAuthorityFactory = AuthorityCodes.this.getFactory();
            try {
                if (this.loadCodes) {
                    list = new ArrayList(100);
                    Iterator iterator = cRSAuthorityFactory.getAuthorityCodes(type).iterator();
                    while (iterator.hasNext()) {
                        list.add((String)iterator.next());
                        if (System.nanoTime() - l <= 100000000L) continue;
                        PartialResult partialResult = new PartialResult(list.toArray(), this.processNameRequests(cRSAuthorityFactory));
                        list.clear();
                        Platform.runLater(() -> AuthorityCodes.this.update(partialResult));
                        l = System.nanoTime();
                    }
                }
                if (list.isEmpty()) {
                    Thread.sleep(100L);
                    return new PartialResult(null, this.processNameRequests(cRSAuthorityFactory));
                }
            }
            catch (BackingStoreException backingStoreException) {
                throw backingStoreException.unwrapOrRethrow(Exception.class);
            }
            return new PartialResult(list.toArray(), null);
        }

        protected void succeeded() {
            AuthorityCodes.this.update((PartialResult)this.getValue());
            this.prepareNewLoader();
        }

        protected void failed() {
            Throwable throwable = this.getException();
            AuthorityCodes.this.errorOccurred(throwable);
            if (this.loadCodes) {
                Code code = new Code(Vocabulary.getResources(AuthorityCodes.this.locale).getString((short)80));
                String string = Exceptions.getLocalizedMessage(throwable, AuthorityCodes.this.locale);
                if (string == null) {
                    string = throwable.getClass().getSimpleName();
                }
                code.name().set(string);
                AuthorityCodes.this.add(code);
            }
            AuthorityCodes.this.removeHourglass();
            this.prepareNewLoader();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prepareNewLoader() {
            boolean bl;
            assert (Platform.isFxApplicationThread());
            this.isRunning = false;
            AuthorityCodes.this.loader = new Loader(this);
            List<Code> list = this.toDescribe;
            synchronized (list) {
                bl = this.toDescribe.isEmpty();
            }
            if (!bl) {
                AuthorityCodes.this.loader.start();
            }
        }
    }

    private static final class PartialResult {
        final Object[] codes;
        final Map<Code, String> names;

        PartialResult(Object[] objectArray, Map<Code, String> map) {
            this.codes = objectArray;
            this.names = map;
        }
    }
}

