/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.metadata;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.function.IntFunction;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.TilePane;
import org.apache.sis.gui.metadata.MetadataSummary;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.util.ArraysExt;
import org.opengis.metadata.Metadata;

abstract class Section<T>
extends GridPane
implements EventHandler<ActionEvent> {
    final MetadataSummary owner;
    static final int NUM_CHILD_PER_LINE = 2;
    private final TilePane pagination;
    private final ToggleGroup pageGroup;
    private T[] information;
    private int rowOfFirstLine;
    private int linesStartIndex;
    private int linesEndIndex;

    Section(MetadataSummary metadataSummary) {
        this.owner = metadataSummary;
        this.pageGroup = new ToggleGroup();
        this.pagination = new TilePane(Orientation.VERTICAL);
        this.pagination.setAlignment(Pos.TOP_RIGHT);
        this.pagination.setVgap(9.0);
        this.pagination.setHgap(9.0);
        this.setPadding(Styles.FORM_INSETS);
        this.setVgap(9.0);
        this.setHgap(9.0);
        this.add((Node)this.pagination, 2, 0);
        Section.setVgrow((Node)this.pagination, (Priority)Priority.ALWAYS);
        Section.setHgrow((Node)this.pagination, (Priority)Priority.NEVER);
        this.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), new ColumnConstraints(100.0, 300.0, Double.MAX_VALUE, Priority.ALWAYS, null, true)});
    }

    final void finished() {
        this.rowOfFirstLine = this.getRowCount();
        this.linesStartIndex = this.getChildren().size();
    }

    final int numPages() {
        return this.information != null ? this.information.length : 0;
    }

    abstract void setInformation(Metadata var1);

    final void setInformation(Collection<? extends T> collection, IntFunction<T[]> intFunction) {
        this.information = collection.toArray(intFunction);
        int n = 0;
        for (Object object : this.information) {
            if (object == null) continue;
            this.information[n++] = object;
        }
        this.information = ArraysExt.resize(this.information, n);
        ObservableList observableList = this.pagination.getChildren();
        int n2 = observableList.size();
        if (n2 < n) {
            NumberFormat numberFormat = this.owner.getNumberFormat();
            do {
                Object object;
                object = new ToggleButton(numberFormat.format(++n2));
                object.setToggleGroup(this.pageGroup);
                object.setOnAction((EventHandler)this);
                observableList.add(object);
            } while (n2 < n);
        } else if (n2 > n) {
            observableList.subList(n, n2).clear();
        }
        this.linesEndIndex = this.linesStartIndex;
        if (n != 0) {
            this.pageGroup.selectToggle((Toggle)((ToggleButton)this.pagination.getChildren().get(0)));
            this.update(0);
        }
    }

    public final void handle(ActionEvent actionEvent) {
        ToggleButton toggleButton = (ToggleButton)actionEvent.getSource();
        if (toggleButton.isSelected()) {
            ObservableList observableList = this.pagination.getChildren();
            int n = observableList.size();
            for (int i = 0; i < n; ++i) {
                if (observableList.get(i) != toggleButton) continue;
                this.update(i);
                break;
            }
        }
    }

    private void update(int n) {
        this.linesEndIndex = this.linesStartIndex;
        this.buildContent(this.information[n]);
        Section.setRowSpan((Node)this.pagination, (Integer)this.nextRowIndex());
        ObservableList observableList = this.getChildren();
        observableList.subList(this.linesEndIndex, observableList.size()).clear();
        Section.setRowSpan((Node)this.pagination, (Integer)this.getRowCount());
    }

    abstract void buildContent(T var1);

    final void addLine(short s, String string) {
        Label label;
        if (string == null) {
            return;
        }
        String string2 = this.owner.vocabulary.getLabel(s);
        ObservableList observableList = this.getChildren();
        if (this.linesEndIndex < observableList.size()) {
            Label label2 = (Label)observableList.get(this.linesEndIndex);
            label = (Label)observableList.get(this.linesEndIndex + 1);
            label2.setText(string2);
        } else {
            int n = this.nextRowIndex();
            Label label3 = new Label(string2);
            label = new Label();
            label3.setLabelFor((Node)label);
            label.setWrapText(true);
            this.add((Node)label3, 0, n);
            this.add((Node)label, 1, n);
            Section.setValignment((Node)label3, (VPos)VPos.TOP);
            Section.setValignment((Node)label, (VPos)VPos.TOP);
        }
        label.setText(string);
        this.linesEndIndex += 2;
    }

    final int nextRowIndex() {
        return (this.linesEndIndex - this.linesStartIndex) / 2 + this.rowOfFirstLine;
    }

    final int linesStartIndex() {
        return this.linesStartIndex;
    }

    boolean isEmpty() {
        return this.linesStartIndex >= this.linesEndIndex;
    }
}

