/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javax.measure.Unit;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.PointOutsideCoverageException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridEvaluator;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.gui.map.StatusBar;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.util.Localized;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.content.TransferFunctionType;

public abstract class ValuesUnderCursor {
    private StatusBar owner;
    protected final Menu valueChoices = new Menu();
    private String lastErrorMessage;

    protected ValuesUnderCursor() {
    }

    public abstract boolean isEmpty();

    public abstract String evaluate(DirectPosition var1);

    final boolean prototype(String string, Iterable<String> iterable) {
        return this.owner == null || this.owner.computeSizeOfSampleValues(string, iterable);
    }

    private static Locale getLocale(ObservableValue<?> observableValue) {
        Object object;
        if (observableValue instanceof ReadOnlyProperty && (object = ((ReadOnlyProperty)observableValue).getBean()) instanceof Localized) {
            return ((Localized)object).getLocale();
        }
        return null;
    }

    static void update(StatusBar statusBar, ValuesUnderCursor valuesUnderCursor, ValuesUnderCursor valuesUnderCursor2) {
        if (valuesUnderCursor != null && valuesUnderCursor.owner == statusBar) {
            valuesUnderCursor.owner = null;
        }
        if (valuesUnderCursor2 != null && valuesUnderCursor2.owner == null) {
            valuesUnderCursor2.owner = statusBar;
        }
    }

    static ValuesUnderCursor create(MapCanvas mapCanvas) {
        if (mapCanvas instanceof CoverageCanvas) {
            FromCoverage fromCoverage = new FromCoverage();
            ObjectProperty<GridCoverage> objectProperty = ((CoverageCanvas)mapCanvas).coverageProperty;
            objectProperty.addListener((ChangeListener)new WeakChangeListener((ChangeListener)fromCoverage));
            GridCoverage gridCoverage = (GridCoverage)objectProperty.get();
            if (gridCoverage != null) {
                fromCoverage.changed(null, null, gridCoverage);
            }
            return fromCoverage;
        }
        return null;
    }

    final void recoverableException(String string, Exception exception) {
        String string2 = exception.getMessage();
        if (!string2.equals(this.lastErrorMessage)) {
            this.lastErrorMessage = string2;
            Logging.recoverableException(Logging.getLogger("org.apache.sis.gui"), ValuesUnderCursor.class, string, exception);
        }
    }

    private static class FromCoverage
    extends ValuesUnderCursor
    implements ChangeListener<GridCoverage> {
        private static final char SEPARATOR = '\u2003';
        private static final int DEFAULT_FORMAT = -1;
        private static final int SCIENTIFIC_NOTATION = -2;
        private GridEvaluator evaluator;
        private final BitSet selectedBands;
        private NumberFormat[] sampleFormats;
        private final StringBuffer buffer = new StringBuffer();
        private final FieldPosition field = new FieldPosition(0);
        private String[] units;
        private final Map<Long, String> nodata = new HashMap<Long, String>();
        private String outsideText;
        private boolean needsBandRefresh;

        public FromCoverage() {
            this.selectedBands = new BitSet();
            this.valueChoices.setText(Vocabulary.format((short)178));
        }

        public final GridCoverage getCoverage() {
            return this.evaluator != null ? this.evaluator.getCoverage() : null;
        }

        @Override
        public boolean isEmpty() {
            return this.selectedBands.isEmpty();
        }

        public void changed(ObservableValue<? extends GridCoverage> observableValue, GridCoverage gridCoverage, GridCoverage gridCoverage2) {
            List list;
            if (gridCoverage2 == null || (list = gridCoverage2.getSampleDimensions()) == null) {
                this.evaluator = null;
                this.units = null;
                this.sampleFormats = null;
                this.outsideText = null;
                this.nodata.clear();
                this.selectedBands.clear();
                this.valueChoices.getItems().clear();
                return;
            }
            this.evaluator = gridCoverage2.forConvertedValues(true).evaluator();
            this.evaluator.setNullIfOutside(true);
            if (gridCoverage != null && list.equals(gridCoverage.getSampleDimensions())) {
                return;
            }
            int n2 = list.size();
            this.units = new String[n2];
            this.sampleFormats = new NumberFormat[n2];
            this.outsideText = null;
            this.selectedBands.clear();
            this.selectedBands.set(0, n2 <= 3 ? n2 : 1, true);
            this.nodata.clear();
            HashMap<Integer, NumberFormat> hashMap = new HashMap<Integer, NumberFormat>();
            HashMap hashMap2 = new HashMap();
            Locale locale = ValuesUnderCursor.getLocale(observableValue);
            UnitFormat unitFormat = new UnitFormat(locale);
            Object[] objectArray = new CheckMenuItem[n2];
            for (int i = 0; i < n2; ++i) {
                Object object2;
                SampleDimension sampleDimension = (SampleDimension)list.get(i);
                objectArray[i] = this.createMenuItem(i, sampleDimension, locale);
                for (Object object2 : sampleDimension.forConvertedValues(true).getCategories()) {
                    float f = ((Number)object2.getSampleRange().getMinValue()).floatValue();
                    if (!Float.isNaN(f)) continue;
                    try {
                        this.nodata.putIfAbsent(FromCoverage.toNodataKey(i, f), object2.getName().toString(locale));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.recoverableException("changed", illegalArgumentException);
                    }
                }
                this.units[i] = sampleDimension.getUnits().map(unit2 -> hashMap2.computeIfAbsent(unit2, unit -> this.format(unitFormat, (Unit<?>)unit))).orElse("");
                SampleDimension sampleDimension2 = sampleDimension.forConvertedValues(false);
                object2 = sampleDimension2.getTransferFunctionFormula().map(transferFunction -> FromCoverage.suggestFractionDigits(transferFunction, sampleDimension2)).orElse(-1);
                this.sampleFormats[i] = hashMap.computeIfAbsent((Integer)object2, n -> {
                    switch (n) {
                        case 0: {
                            return NumberFormat.getIntegerInstance(locale);
                        }
                        case -1: {
                            return NumberFormat.getNumberInstance(locale);
                        }
                        case -2: {
                            NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
                            if (n == -2 && numberFormat instanceof DecimalFormat) {
                                ((DecimalFormat)numberFormat).applyPattern("0.000E00");
                            }
                            return numberFormat;
                        }
                    }
                    NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
                    numberFormat.setMinimumFractionDigits((int)n);
                    numberFormat.setMaximumFractionDigits((int)n);
                    return numberFormat;
                });
            }
            this.valueChoices.getItems().setAll(objectArray);
            this.onBandSelectionChanged();
        }

        private static Long toNodataKey(int n, float f) {
            return (long)MathFunctions.toNanOrdinal(f) << 32 | (long)n;
        }

        private static Integer suggestFractionDigits(TransferFunction transferFunction, SampleDimension sampleDimension) {
            int n;
            if (transferFunction.getType() != TransferFunctionType.LINEAR) {
                n = -2;
            } else {
                double d = transferFunction.getScale();
                if (d > 0.0 && d <= Double.MAX_VALUE) {
                    Optional optional = sampleDimension.getSampleRange();
                    if (optional.isPresent()) {
                        d *= 0.5 / ((NumberRange)optional.get()).getSpan() + 1.0;
                    }
                    if ((n = DecimalFunctions.fractionDigitsForDelta(d, false)) < -9 || n > 6) {
                        n = -2;
                    }
                } else {
                    n = -1;
                }
            }
            return n;
        }

        private CheckMenuItem createMenuItem(int n, SampleDimension sampleDimension, Locale locale) {
            CheckMenuItem checkMenuItem = new CheckMenuItem(sampleDimension.getName().toInternationalString().toString(locale));
            checkMenuItem.setSelected(this.selectedBands.get(n));
            checkMenuItem.selectedProperty().addListener((observableValue, bl, bl2) -> {
                this.selectedBands.set(n, (boolean)bl2);
                this.onBandSelectionChanged();
            });
            return checkMenuItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String evaluate(DirectPosition directPosition) {
            if (this.needsBandRefresh && this.evaluator != null) {
                this.onBandSelectionChanged();
            }
            if (directPosition != null) {
                StringBuffer stringBuffer = this.buffer;
                synchronized (stringBuffer) {
                    block15: {
                        this.buffer.setLength(0);
                        if (this.evaluator != null) {
                            try {
                                double[] dArray = this.evaluator.apply(directPosition);
                                if (dArray == null) break block15;
                                int n = -1;
                                while ((n = this.selectedBands.nextSetBit(n + 1)) >= 0) {
                                    double d;
                                    if (this.buffer.length() != 0) {
                                        this.buffer.append('\u2003');
                                    }
                                    if (Double.isNaN(d = dArray[n])) {
                                        try {
                                            String string = this.nodata.get(FromCoverage.toNodataKey(n, (float)d));
                                            if (string != null) {
                                                return string;
                                            }
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            this.recoverableException("evaluate", illegalArgumentException);
                                        }
                                    }
                                    this.sampleFormats[n].format(d, this.buffer, this.field).append(this.units[n]);
                                }
                                return this.buffer.toString();
                            }
                            catch (PointOutsideCoverageException pointOutsideCoverageException) {
                            }
                            catch (CannotEvaluateException cannotEvaluateException) {
                                this.recoverableException("evaluate", (Exception)((Object)cannotEvaluateException));
                            }
                        }
                    }
                }
            }
            return this.outsideText;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String format(UnitFormat unitFormat, Unit<?> unit) {
            StringBuffer stringBuffer = this.buffer;
            synchronized (stringBuffer) {
                this.buffer.setLength(0);
                unitFormat.format(unit, this.buffer, this.field);
                if (this.buffer.length() != 0 && Character.isLetterOrDigit(this.buffer.codePointAt(0))) {
                    this.buffer.insert(0, '\u00a0');
                }
                return this.buffer.toString();
            }
        }

        /*
         * Exception decompiling
         */
        private void onBandSelectionChanged() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AssignmentExpression.applyExpressionRewriter(AssignmentExpression.java:68)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIter.rewriteExpressions(StructuredIter.java:119)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ Comparable[] lambda$onBandSelectionChanged$6() {
            return new Comparable[]{Integer.valueOf(65535)};
        }
    }
}

