/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.CoordinateFormat;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.gui.Widget;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.gui.map.OperationFinder;
import org.apache.sis.gui.map.ValuesUnderCursor;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.portrayal.RenderException;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public class StatusBar
extends Widget
implements EventHandler<MouseEvent> {
    private static final int BIDIMENSIONAL = 2;
    private static final Insets PADDING = new Insets(5.0, 20.0, 6.0, 9.0);
    private final HBox view;
    private final Label message;
    private double lastX;
    private double lastY;
    private final MapCanvas canvas;
    private final RecentReferenceSystems systemChooser;
    private final ObjectProperty<ReferenceSystem> selectedSystem;
    private CoordinateReferenceSystem objectiveCRS;
    private MathTransform objectiveToPositionCRS;
    public final ObjectProperty<MathTransform> localToObjectiveCRS;
    public final ReadOnlyObjectProperty<ReferenceSystem> positionReferenceSystem = new PositionSystem();
    private MathTransform localToPositionCRS;
    private Predicate<MapCanvas> fullOperationSearchRequired;
    private double[] sourceCoordinates;
    private GeneralDirectPosition targetCoordinates;
    private double[] precisions;
    private double[] inflatePrecisions;
    private Quantity<Length> lowestAccuracy;
    private final CoordinateFormat format;
    protected final Label position;
    private int maximalPositionLength;
    private String outsideText;
    private Label sampleValues;
    public final ObjectProperty<ValuesUnderCursor> sampleValuesProvider;
    private boolean isSampleValuesVisible;

    public StatusBar(RecentReferenceSystems recentReferenceSystems, MapCanvas ... mapCanvasArray) {
        Menu menu;
        this.localToObjectiveCRS = new LocalToObjective();
        this.localToPositionCRS = (MathTransform)this.localToObjectiveCRS.get();
        this.targetCoordinates = new GeneralDirectPosition(2);
        this.sourceCoordinates = this.targetCoordinates.coordinates;
        this.lastY = Double.NaN;
        this.lastX = Double.NaN;
        this.format = new CoordinateFormat();
        this.message = new Label();
        this.message.setVisible(false);
        this.message.setTextFill((Paint)Styles.ERROR_TEXT);
        this.message.setMaxWidth(Double.POSITIVE_INFINITY);
        HBox.setHgrow((Node)this.message, (Priority)Priority.ALWAYS);
        this.position = new Label();
        this.position.setAlignment(Pos.CENTER_RIGHT);
        this.position.setTextAlignment(TextAlignment.RIGHT);
        this.view = new HBox(18.0, new Node[]{this.message, this.position});
        this.view.setPadding(PADDING);
        this.view.setAlignment(Pos.CENTER_RIGHT);
        ContextMenu contextMenu = new ContextMenu();
        this.view.setOnMousePressed(mouseEvent -> {
            if (mouseEvent.isSecondaryButtonDown() && !contextMenu.getItems().isEmpty()) {
                contextMenu.show((Node)((HBox)mouseEvent.getSource()), mouseEvent.getScreenX(), mouseEvent.getScreenY());
                mouseEvent.consume();
            } else {
                contextMenu.hide();
            }
        });
        this.systemChooser = recentReferenceSystems;
        if (recentReferenceSystems == null) {
            this.selectedSystem = null;
        } else {
            menu = recentReferenceSystems.createMenuItems((ChangeListener<ReferenceSystem>)((ChangeListener)(observableValue, referenceSystem, referenceSystem2) -> this.setPositionCRS(referenceSystem2 instanceof CoordinateReferenceSystem ? (CoordinateReferenceSystem)referenceSystem2 : null)));
            this.selectedSystem = RecentReferenceSystems.getSelectedProperty(menu);
            contextMenu.getItems().add((Object)menu);
            recentReferenceSystems.getItems().addListener(change -> {
                while (change.next()) {
                    if (!change.wasAdded() && !change.wasReplaced()) continue;
                    this.setReplaceablePositionCRS(this.format.getDefaultCRS());
                    break;
                }
            });
        }
        menu = contextMenu.getItems();
        this.sampleValuesProvider = new SimpleObjectProperty((Object)this, "valueProvider");
        this.sampleValuesProvider.addListener((arg_0, arg_1, arg_2) -> this.lambda$new$3((ObservableList)menu, arg_0, arg_1, arg_2));
        if (mapCanvasArray != null && mapCanvasArray.length != 0) {
            if (mapCanvasArray.length != 1) {
                throw new IllegalArgumentException(Errors.format((short)35, "toTrack", 1, mapCanvasArray.length));
            }
            this.canvas = mapCanvasArray[0];
        } else {
            this.canvas = null;
        }
        if (this.canvas != null) {
            this.sampleValuesProvider.set((Object)ValuesUnderCursor.create(this.canvas));
            this.canvas.errorProperty().addListener((observableValue, throwable, throwable2) -> this.setRenderingError((Throwable)throwable2));
            this.canvas.renderingProperty().addListener((observableValue, bl, bl2) -> {
                if (!bl2.booleanValue()) {
                    this.applyCanvasGeometry();
                }
            });
            this.applyCanvasGeometry();
            if (this.canvas.getObjectiveCRS() != null) {
                this.registerMouseListeners();
            } else {
                this.canvas.addPropertyChangeListener("objectiveCRS", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        StatusBar.this.canvas.removePropertyChangeListener("objectiveCRS", this);
                        StatusBar.this.registerMouseListeners();
                    }
                });
            }
        }
    }

    private void registerMouseListeners() {
        Pane pane = this.canvas.floatingPane;
        pane.addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)this);
        pane.addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)this);
        pane.addEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)this);
    }

    @Override
    public final Region getView() {
        return this.view;
    }

    private void applyCanvasGeometry() {
        try {
            this.apply(this.canvas.getGridGeometry());
        }
        catch (RenderException renderException) {
            this.setRenderingError(renderException);
        }
    }

    public void applyCanvasGeometry(GridGeometry gridGeometry) {
        this.position.setText(null);
        this.apply(gridGeometry);
    }

    private void apply(GridGeometry gridGeometry) {
        int n;
        LinearTransform linearTransform = null;
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        double d = 1.0;
        double[] dArray = null;
        Unit unit = Units.PIXEL;
        if (gridGeometry != null) {
            Object object;
            if (gridGeometry.isDefined(1)) {
                coordinateReferenceSystem = gridGeometry.getCoordinateReferenceSystem();
            }
            if (gridGeometry.isDefined(8)) {
                linearTransform = gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER);
            }
            if (gridGeometry.isDefined(16)) {
                object = gridGeometry.getResolution(true);
                if (coordinateReferenceSystem != null && ((double[])object).length != 0) {
                    CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
                    unit = coordinateSystem.getAxis(0).getUnit();
                    for (n = 0; n < ((double[])object).length; ++n) {
                        double d2;
                        if (!unit.equals(coordinateSystem.getAxis(n).getUnit()) || !((d2 = object[n]) < d)) continue;
                        d = d2;
                    }
                }
            }
            if (gridGeometry.isDefined(4)) {
                object = gridGeometry.getExtent();
                int n2 = object.getDimension();
                dArray = new double[n2];
                for (n = 0; n < n2; ++n) {
                    dArray[n] = 0.5 / (double)object.getSize(n) + 1.0;
                }
            }
        }
        boolean bl = Utilities.equalsIgnoreMetadata(this.objectiveCRS, coordinateReferenceSystem);
        if (linearTransform == null) {
            linearTransform = MathTransforms.identity((int)2);
        }
        int n3 = Math.max(linearTransform.getSourceDimensions(), 2);
        n = linearTransform.getTargetDimensions();
        ((LocalToObjective)this.localToObjectiveCRS).setNoCheck((MathTransform)linearTransform);
        this.targetCoordinates = new GeneralDirectPosition(n);
        this.sourceCoordinates = n3 == n ? this.targetCoordinates.coordinates : new double[n3];
        this.objectiveCRS = coordinateReferenceSystem;
        this.localToPositionCRS = linearTransform;
        this.inflatePrecisions = dArray;
        this.precisions = null;
        this.lastY = Double.NaN;
        this.lastX = Double.NaN;
        if (bl) {
            this.updateLocalToPositionCRS();
            if (this.fullOperationSearchRequired != null && this.fullOperationSearchRequired.test(this.canvas)) {
                this.setPositionCRS(this.format.getDefaultCRS());
            }
        } else {
            this.objectiveToPositionCRS = null;
            this.setFormatCRS(coordinateReferenceSystem, null);
            coordinateReferenceSystem = OperationFinder.toGeospatial(coordinateReferenceSystem, this.canvas);
            coordinateReferenceSystem = this.setReplaceablePositionCRS(coordinateReferenceSystem);
        }
        this.format.setGroundPrecision(Quantities.create(d, unit));
        if (!bl && this.selectedSystem != null) {
            this.selectedSystem.set((Object)coordinateReferenceSystem);
        }
    }

    private void updateLocalToPositionCRS() {
        if (this.objectiveToPositionCRS != null) {
            this.localToPositionCRS = MathTransforms.concatenate((MathTransform)((MathTransform)this.localToObjectiveCRS.get()), (MathTransform)this.objectiveToPositionCRS);
        }
        this.setTargetCRS(this.format.getDefaultCRS());
    }

    private void setTargetCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        int n = ReferencingUtilities.getDimension((CoordinateReferenceSystem)coordinateReferenceSystem);
        if (n != 0 && n != this.targetCoordinates.getDimension()) {
            this.precisions = null;
            this.targetCoordinates = new GeneralDirectPosition(n);
            if (this.sourceCoordinates.length == n) {
                this.sourceCoordinates = this.targetCoordinates.coordinates;
            }
        }
        this.targetCoordinates.setCoordinateReferenceSystem(coordinateReferenceSystem);
    }

    private CoordinateReferenceSystem setReplaceablePositionCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem != null && this.systemChooser != null) {
            ComparisonMode comparisonMode = (ComparisonMode)((Object)this.systemChooser.duplicationCriterion.get());
            for (ReferenceSystem referenceSystem : this.systemChooser.getItems()) {
                if (!Utilities.deepEquals(coordinateReferenceSystem, referenceSystem, comparisonMode)) continue;
                coordinateReferenceSystem = (CoordinateReferenceSystem)referenceSystem;
                break;
            }
        }
        if (coordinateReferenceSystem != this.format.getDefaultCRS()) {
            this.setPositionCRS(coordinateReferenceSystem);
        }
        return coordinateReferenceSystem;
    }

    private void setPositionCRS(final CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem != null && this.objectiveCRS != null && this.objectiveCRS != coordinateReferenceSystem) {
            this.position.setTextFill((Paint)Styles.OUTDATED_TEXT);
            Envelope envelope = this.systemChooser != null ? (Envelope)this.systemChooser.areaOfInterest.get() : null;
            BackgroundThreads.execute((Runnable)((Object)new OperationFinder(this.canvas, envelope, this.objectiveCRS, coordinateReferenceSystem){
                private Quantity<Length> accuracy;

                @Override
                protected MathTransform call() throws Exception {
                    MathTransform mathTransform = super.call();
                    double d = CRS.getLinearAccuracy((CoordinateOperation)this.getOperation());
                    if (d > 0.0) {
                        this.accuracy = GUIUtilities.shorter(null, d);
                    }
                    return mathTransform;
                }

                protected void succeeded() {
                    StatusBar.this.setPositionCRS(this, this.accuracy);
                }

                protected void failed() {
                    Locale locale = StatusBar.this.getLocale();
                    StatusBar.this.setErrorMessage(Resources.forLocale(locale).getString((short)9, IdentifiedObjects.getDisplayName((IdentifiedObject)coordinateReferenceSystem, (Locale)locale)), this.getException());
                    StatusBar.this.selectedSystem.set((Object)StatusBar.this.format.getDefaultCRS());
                    StatusBar.this.resetPositionCRS(Styles.ERROR_TEXT);
                }

                @Override
                protected Class<?> getCallerClass() {
                    return StatusBar.class;
                }

                @Override
                protected String getCallerMethod() {
                    return "setPositionCRS";
                }
            }));
        } else {
            if (this.objectiveCRS == null) {
                this.objectiveCRS = coordinateReferenceSystem;
            }
            this.position.setMinWidth(0.0);
            this.maximalPositionLength = 0;
            this.resetPositionCRS(Styles.NORMAL_TEXT);
        }
    }

    private void setPositionCRS(OperationFinder operationFinder, Quantity<Length> quantity) {
        this.setErrorMessage(null, null);
        this.setFormatCRS(operationFinder.getTargetCRS(), quantity);
        this.objectiveToPositionCRS = (MathTransform)operationFinder.getValue();
        this.fullOperationSearchRequired = operationFinder.fullOperationSearchRequired();
        this.updateLocalToPositionCRS();
        this.position.setTextFill((Paint)Styles.NORMAL_TEXT);
        this.position.setMinWidth(0.0);
        this.maximalPositionLength = 0;
        if (this.isPositionVisible()) {
            double d = this.lastX;
            double d2 = this.lastY;
            this.lastY = Double.NaN;
            this.lastX = Double.NaN;
            if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                this.setLocalCoordinates(d, d2);
            }
        }
    }

    private void setFormatCRS(CoordinateReferenceSystem coordinateReferenceSystem, Quantity<Length> quantity) {
        int n;
        CoordinateSystem coordinateSystem;
        this.format.setDefaultCRS(coordinateReferenceSystem);
        this.format.setGroundAccuracy(Quantities.max(quantity, this.lowestAccuracy));
        String string = IdentifiedObjects.getDisplayName((IdentifiedObject)coordinateReferenceSystem, (Locale)this.getLocale());
        Tooltip tooltip = null;
        if (string != null) {
            tooltip = this.position.getTooltip();
            if (tooltip == null) {
                tooltip = new Tooltip(string);
            } else {
                tooltip.setText(string);
            }
        }
        this.position.setTooltip(tooltip);
        string = null;
        if (coordinateReferenceSystem != null && (coordinateSystem = coordinateReferenceSystem.getCoordinateSystem()) != null && (n = coordinateSystem.getDimension()) > 0) {
            StringBuilder stringBuilder = new StringBuilder().append('(');
            for (int i = 0; i < n; ++i) {
                String string2;
                CoordinateSystemAxis coordinateSystemAxis;
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                if ((coordinateSystemAxis = coordinateSystem.getAxis(i)) != null && (string2 = Strings.trimOrNull(coordinateSystemAxis.getAbbreviation())) != null) {
                    stringBuilder.append(string2);
                    continue;
                }
                stringBuilder.append('?');
            }
            stringBuilder.append(')');
            this.format.getGroundAccuracyText().ifPresent(stringBuilder::append);
            string = stringBuilder.toString();
        }
        if (this.position.getText() == this.outsideText) {
            this.position.setText(string);
        }
        this.outsideText = string;
        this.setTargetCRS(coordinateReferenceSystem);
        ((PositionSystem)this.positionReferenceSystem).fireValueChangedEvent();
    }

    private void resetPositionCRS(Color color) {
        this.objectiveToPositionCRS = null;
        this.localToPositionCRS = (MathTransform)this.localToObjectiveCRS.get();
        this.setFormatCRS(this.objectiveCRS, null);
        this.position.setTextFill((Paint)color);
    }

    public Quantity<Length> getLowestAccuracy() {
        return this.lowestAccuracy;
    }

    public void setLowestAccuracy(Quantity<Length> quantity) {
        this.lowestAccuracy = quantity;
    }

    public Optional<Point2D> getLocalCoordinates() {
        if (this.isPositionVisible() && !Double.isNaN(this.lastX) && !Double.isNaN(this.lastY)) {
            return Optional.of(new Point2D(this.lastX, this.lastY));
        }
        return Optional.empty();
    }

    public void setLocalCoordinates(double d, double d2) {
        if (d != this.lastX || d2 != this.lastY) {
            String string;
            this.sourceCoordinates[0] = this.lastX = d;
            this.sourceCoordinates[1] = this.lastY = d2;
            String string2 = null;
            try {
                this.convertCoordinates();
                if (this.isSampleValuesVisible) {
                    string2 = ((ValuesUnderCursor)this.sampleValuesProvider.get()).evaluate((DirectPosition)this.targetCoordinates);
                }
                this.targetCoordinates.normalize();
                string = this.format.format((DirectPosition)this.targetCoordinates);
            }
            catch (RuntimeException | TransformException throwable) {
                Exception exception = Exceptions.unwrap((Exception)throwable);
                string = exception.getLocalizedMessage();
                if (string == null) {
                    string = Classes.getShortClassName(exception);
                }
                string2 = null;
            }
            this.position.setText(string);
            if (this.isSampleValuesVisible) {
                this.sampleValues.setText(string2);
            }
            if (string.length() > this.maximalPositionLength) {
                this.maximalPositionLength = string.length();
                this.position.setMinWidth(Math.min(this.view.getWidth() / 2.0, Math.ceil(this.position.prefWidth(this.position.getHeight()))));
            }
        }
    }

    private void convertCoordinates() throws TransformException {
        Matrix matrix;
        try {
            matrix = MathTransforms.derivativeAndTransform((MathTransform)this.localToPositionCRS, (double[])this.sourceCoordinates, (int)0, (double[])this.targetCoordinates.coordinates, (int)0);
        }
        catch (TransformException transformException) {
            this.localToPositionCRS.transform(this.sourceCoordinates, 0, this.targetCoordinates.coordinates, 0, 1);
            matrix = null;
        }
        if (matrix == null) {
            this.precisions = null;
        } else {
            if (this.precisions == null) {
                this.precisions = new double[this.targetCoordinates.getDimension()];
            }
            int n = matrix.getNumRow();
            while (--n >= 0) {
                double d = 0.0;
                int n2 = matrix.getNumCol();
                while (--n2 >= 0) {
                    double d2 = Math.abs(matrix.getElement(n, n2));
                    if (this.inflatePrecisions != null) {
                        d2 *= this.inflatePrecisions[n2];
                    }
                    if (!(d2 > d)) continue;
                    d = d2;
                }
                this.precisions[n] = d;
            }
        }
        this.format.setPrecisions(this.precisions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String formatCoordinates(double d, double d2) throws TransformException {
        this.sourceCoordinates[0] = d;
        this.sourceCoordinates[1] = d2;
        String string = this.format.getSeparator();
        try {
            this.format.setSeparator("\t");
            this.convertCoordinates();
            String string2 = this.format.format((DirectPosition)this.targetCoordinates);
            return string2;
        }
        finally {
            this.format.setSeparator(string);
        }
    }

    public void handle(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            EventType eventType = mouseEvent.getEventType();
            if (eventType == MouseEvent.MOUSE_MOVED || eventType == MouseEvent.MOUSE_ENTERED) {
                this.setLocalCoordinates(mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (eventType != MouseEvent.MOUSE_EXITED) {
                return;
            }
        }
        this.position.setText(this.outsideText);
        if (this.isSampleValuesVisible) {
            this.sampleValues.setText(((ValuesUnderCursor)this.sampleValuesProvider.get()).evaluate(null));
        }
    }

    private boolean isPositionVisible() {
        if (this.position.isVisible()) {
            String string = this.position.getText();
            return string != null && string != this.outsideText;
        }
        return false;
    }

    private void setSampleValuesVisible(boolean bl) {
        ObservableList observableList = this.view.getChildren();
        if (bl) {
            if (this.sampleValues == null) {
                this.sampleValues = new Label();
                this.sampleValues.setAlignment(Pos.CENTER_RIGHT);
                this.sampleValues.setTextAlignment(TextAlignment.RIGHT);
                this.sampleValues.setMinWidth(Double.NEGATIVE_INFINITY);
                this.sampleValues.setMaxWidth(Double.NEGATIVE_INFINITY);
            }
            if (observableList.lastIndexOf((Object)this.sampleValues) < 0) {
                observableList.add((Object)this.sampleValues);
            }
        } else if (this.sampleValues != null) {
            this.sampleValues.setText(null);
            observableList.remove((Object)this.sampleValues);
        }
        this.isSampleValuesVisible = bl;
    }

    final boolean computeSizeOfSampleValues(String string, Iterable<String> iterable) {
        this.setSampleValuesVisible(string != null && !string.isEmpty());
        if (this.isSampleValuesVisible) {
            this.sampleValues.setText(string);
            this.sampleValues.setPrefWidth(-1.0);
            double d = this.sampleValues.prefWidth(this.sampleValues.getHeight());
            double d2 = Math.max(d * 1.25, 200.0);
            for (String string2 : iterable) {
                this.sampleValues.setText(string2);
                double d3 = this.sampleValues.prefWidth(this.sampleValues.getHeight());
                if (!(d3 > d) || !((d = d3) > d2)) continue;
                d = d2;
                break;
            }
            this.sampleValues.setText(null);
            if (!(d > 0.0)) {
                return false;
            }
            this.sampleValues.setPrefWidth(d);
        }
        return true;
    }

    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.message.getText());
    }

    public void setErrorMessage(String string, Throwable throwable) {
        string = Strings.trimOrNull(string);
        Button button = null;
        if (throwable != null) {
            Locale locale = this.getLocale();
            if (string == null && (string = Exceptions.getLocalizedMessage(throwable, locale)) == null) {
                string = throwable.getClass().getSimpleName();
            }
            String string2 = string;
            button = new Button("\u2139\ufe0f");
            button.setOnAction(actionEvent -> ExceptionReporter.show((Node)this.getView(), Resources.forLocale(locale).getString((short)17), string2, throwable));
        }
        this.message.setVisible(string != null);
        this.message.setGraphic(button);
        this.message.setText(string);
        this.message.setTextFill((Paint)Styles.ERROR_TEXT);
    }

    private void setRenderingError(Throwable throwable) {
        String string = null;
        if (throwable != null) {
            string = Resources.forLocale(this.getLocale()).getString((short)8);
        }
        this.setErrorMessage(string, throwable);
    }

    private Locale getLocale() {
        return this.format.getLocale(Locale.Category.DISPLAY);
    }

    private /* synthetic */ void lambda$new$3(ObservableList observableList, ObservableValue observableValue, ValuesUnderCursor valuesUnderCursor, ValuesUnderCursor valuesUnderCursor2) {
        ValuesUnderCursor.update(this, valuesUnderCursor, valuesUnderCursor2);
        if (valuesUnderCursor != null) {
            observableList.remove((Object)valuesUnderCursor.valueChoices);
        }
        if (valuesUnderCursor2 != null) {
            observableList.add(0, (Object)valuesUnderCursor2.valueChoices);
        }
        this.setSampleValuesVisible(valuesUnderCursor2 != null && !valuesUnderCursor2.isEmpty());
    }

    private final class PositionSystem
    extends ReadOnlyObjectPropertyBase<ReferenceSystem> {
        private PositionSystem() {
        }

        public Object getBean() {
            return StatusBar.this;
        }

        public String getName() {
            return "positionReferenceSystem";
        }

        public ReferenceSystem get() {
            return StatusBar.this.format.getDefaultCRS();
        }

        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }
    }

    private final class LocalToObjective
    extends ObjectPropertyBase<MathTransform> {
        LocalToObjective() {
            super((Object)MathTransforms.identity((int)2));
        }

        public Object getBean() {
            return StatusBar.this;
        }

        public String getName() {
            return "localToObjectiveCRS";
        }

        final void setNoCheck(MathTransform mathTransform) {
            super.set((Object)mathTransform);
        }

        public void set(MathTransform mathTransform) {
            ArgumentChecks.ensureNonNull("newValue", mathTransform);
            MathTransform mathTransform2 = (MathTransform)this.get();
            ArgumentChecks.ensureDimensionsMatch("newValue", mathTransform2.getSourceDimensions(), mathTransform2.getTargetDimensions(), mathTransform);
            super.set((Object)mathTransform);
            StatusBar.this.updateLocalToPositionCRS();
        }
    }
}

