/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.gui.map.StatusBar;
import org.apache.sis.gui.referencing.PositionableProjection;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class MapMenu
extends ContextMenu {
    private final MapCanvas canvas;
    private MapCanvas.MenuHandler menuHandler;
    private int defined;
    private static final int CRS = 1;
    private static final int COPY = 2;

    public MapMenu(MapCanvas mapCanvas) {
        ArgumentChecks.ensureNonNull("canvas", mapCanvas);
        this.canvas = mapCanvas;
    }

    private MapCanvas.MenuHandler startNewMenuItems(int n) {
        if ((this.defined & n) != 0) {
            throw new IllegalStateException();
        }
        this.defined |= n;
        if (this.menuHandler == null) {
            MapCanvas mapCanvas = this.canvas;
            Objects.requireNonNull(mapCanvas);
            this.menuHandler = mapCanvas.new MapCanvas.MenuHandler(this);
        }
        return this.menuHandler;
    }

    public void addReferenceSystems(RecentReferenceSystems recentReferenceSystems) {
        ArgumentChecks.ensureNonNull("preferences", recentReferenceSystems);
        MapCanvas.MenuHandler menuHandler = this.startNewMenuItems(1);
        Menu menu = recentReferenceSystems.createMenuItems(menuHandler);
        menuHandler.selectedCrsProperty = RecentReferenceSystems.getSelectedProperty(menu);
        menuHandler.positionables = new ToggleGroup();
        Resources resources = Resources.forLocale(this.canvas.getLocale());
        Menu menu2 = new Menu(resources.getString((short)43));
        for (PositionableProjection positionableProjection : PositionableProjection.values()) {
            RadioMenuItem radioMenuItem = new RadioMenuItem(positionableProjection.toString());
            radioMenuItem.setToggleGroup(menuHandler.positionables);
            radioMenuItem.setOnAction(actionEvent -> menuHandler.createProjectedCRS(positionableProjection));
            menu2.getItems().add((Object)radioMenuItem);
        }
        this.getItems().addAll((Object[])new MenuItem[]{menu, menu2});
        this.canvas.addPropertyChangeListener("objectiveCRS", menuHandler);
    }

    public void addCopyOptions(StatusBar statusBar) {
        ArgumentChecks.ensureNonNull("format", statusBar);
        MapCanvas.MenuHandler menuHandler = this.startNewMenuItems(2);
        Resources resources = Resources.forLocale(this.canvas.getLocale());
        MenuItem menuItem = resources.menu((short)50, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            try {
                String string = statusBar.formatCoordinates(menuHandler.x, menuHandler.y);
                ClipboardContent clipboardContent = new ClipboardContent();
                clipboardContent.putString(string);
                Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
            }
            catch (RuntimeException | TransformException throwable) {
                ExceptionReporter.show(this.getOwnerWindow(), ((MenuItem)actionEvent.getSource()).getText(), null, throwable);
            }
        }));
        this.getItems().add((Object)menuItem);
    }

    public Optional<ObservableObjectValue<String>> selectedReferenceSystem() {
        ObjectProperty<ReferenceSystem> objectProperty;
        if (this.menuHandler != null && (objectProperty = this.menuHandler.selectedCrsProperty) != null) {
            return Optional.of(new SelectedCRS(objectProperty, this.canvas.getLocale()));
        }
        return Optional.empty();
    }

    private static final class SelectedCRS
    extends ObjectBinding<String> {
        private final ObjectProperty<ReferenceSystem> selectedSystem;
        private final Locale locale;

        SelectedCRS(ObjectProperty<ReferenceSystem> objectProperty, Locale locale) {
            this.selectedSystem = objectProperty;
            this.locale = locale;
            this.bind(new Observable[]{objectProperty});
        }

        protected String computeValue() {
            return IdentifiedObjects.getDisplayName((IdentifiedObject)((IdentifiedObject)this.selectedSystem.get()), (Locale)this.locale);
        }
    }
}

