/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.stage.Stage;
import org.apache.sis.gui.Widget;
import org.apache.sis.gui.dataset.DataWindow;
import org.apache.sis.gui.dataset.SelectedData;
import org.apache.sis.internal.gui.Resources;

abstract class WindowManager
extends Widget {
    private final List<MenuItem> newWindowMenus = new ArrayList<MenuItem>(2);
    private ObservableList<MenuItem> showWindowMenus;
    public final ReadOnlyBooleanProperty hasWindowsProperty = new WindowsProperty();

    WindowManager() {
    }

    abstract Resources localized();

    public final MenuItem createNewWindowMenu() {
        MenuItem menuItem = this.localized().menu((short)26, (EventHandler<ActionEvent>)((EventHandler)this::newDataWindow));
        menuItem.setDisable(true);
        this.newWindowMenus.add(menuItem);
        return menuItem;
    }

    public void setWindowsItems(ObservableList<MenuItem> observableList) {
        this.showWindowMenus = observableList;
    }

    final void setNewWindowDisabled(boolean bl) {
        for (MenuItem menuItem : this.newWindowMenus) {
            menuItem.setDisable(bl);
        }
    }

    abstract SelectedData getSelectedData();

    private void newDataWindow(ActionEvent actionEvent2) {
        SelectedData selectedData = this.getSelectedData();
        if (selectedData != null) {
            DataWindow dataWindow = new DataWindow((EventObject)actionEvent2, (Stage)this.getView().getScene().getWindow(), selectedData);
            dataWindow.setTitle(selectedData.title + " \u2014 Apache SIS");
            dataWindow.show();
            if (this.showWindowMenus != null) {
                int n = this.showWindowMenus.size();
                do {
                    if (--n >= 0) continue;
                    n = 0;
                    this.showWindowMenus.add(0, (Object)new SeparatorMenuItem());
                    ((WindowsProperty)this.hasWindowsProperty).set(true);
                    break;
                } while (!(this.showWindowMenus.get(n) instanceof SeparatorMenuItem));
                MenuItem menuItem = new MenuItem(selectedData.title);
                menuItem.setOnAction(actionEvent -> dataWindow.toFront());
                this.showWindowMenus.add(n, (Object)menuItem);
                dataWindow.setOnHidden(windowEvent -> this.removeDataWindow(menuItem));
            }
        }
    }

    private void removeDataWindow(MenuItem menuItem) {
        ObservableList<MenuItem> observableList = this.showWindowMenus;
        if (observableList != null) {
            int n = observableList.size();
            while (--n >= 0) {
                if (observableList.get(n) != menuItem) continue;
                observableList.remove(n);
                if (n != 0) break;
                if (!observableList.isEmpty()) {
                    if (!(observableList.get(0) instanceof SeparatorMenuItem)) break;
                    observableList.remove(0);
                }
                ((WindowsProperty)this.hasWindowsProperty).set(false);
                break;
            }
        }
    }

    private final class WindowsProperty
    extends ReadOnlyBooleanPropertyBase {
        private boolean hasWindows;

        private WindowsProperty() {
        }

        final void set(boolean bl) {
            this.hasWindows = bl;
            this.fireValueChangedEvent();
        }

        public boolean get() {
            return this.hasWindows;
        }

        public Object getBean() {
            return WindowManager.this;
        }

        public String getName() {
            return "hasWindows";
        }
    }
}

