/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableListBase;
import javafx.concurrent.Worker;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.gui.dataset.FeatureLoader;
import org.apache.sis.gui.dataset.FeatureTable;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.util.ArraysExt;

final class FeatureList
extends ObservableListBase<AbstractFeature> {
    private static final long NUM_PENDING_ROWS = 10L;
    private static final int MAXIMUM_ROWS = 0x7FFFFFFE;
    private static final AbstractFeature[] EMPTY = new AbstractFeature[0];
    private AbstractFeature[] elements = EMPTY;
    private int validCount;
    private int estimatedSize;
    private boolean isSizeExact;
    private FeatureLoader nextPageLoader;

    FeatureList() {
    }

    private List<AbstractFeature> validElements() {
        return UnmodifiableArrayList.wrap(this.elements, 0, this.validCount);
    }

    public void clear() {
        List<AbstractFeature> list = this.validElements();
        this.elements = EMPTY;
        this.estimatedSize = 0;
        this.validCount = 0;
        this.beginChange();
        this.nextReplace(0, 0, list);
        this.endChange();
    }

    final boolean startFeaturesLoading(FeatureTable featureTable, FeatureSet featureSet) {
        assert (Platform.isFxApplicationThread());
        FeatureLoader featureLoader = this.nextPageLoader;
        if (featureLoader != null) {
            this.nextPageLoader = null;
            featureLoader.cancel();
        }
        if (featureSet != null) {
            this.nextPageLoader = new FeatureLoader(featureTable, featureSet);
            BackgroundThreads.execute((Runnable)((Object)this.nextPageLoader));
            return true;
        }
        this.clear();
        return false;
    }

    final void setFeatures(long l, int n, AbstractFeature[] abstractFeatureArray, int n2, boolean bl) {
        assert (Platform.isFxApplicationThread());
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            AbstractFeature abstractFeature = abstractFeatureArray[i];
            if (abstractFeature == null) continue;
            abstractFeatureArray[n3++] = abstractFeature;
        }
        List<AbstractFeature> list = this.validElements();
        if (l == Long.MAX_VALUE) {
            l = (long)n2 + 10L;
            n = 0;
        }
        this.estimatedSize = (int)Math.min(0x7FFFFFFEL, Math.addExact(l, (long)n3));
        this.isSizeExact = (n & 0x40) != 0;
        this.elements = abstractFeatureArray;
        this.validCount = n3;
        if (bl && this.estimatedSize <= n3) {
            this.estimatedSize = (int)Math.min(0x7FFFFFFEL, (long)n3 + 10L);
        }
        this.beginChange();
        this.nextReplace(0, this.estimatedSize, list);
        this.endChange();
        this.checkOverflow();
    }

    final void addFeatures(AbstractFeature[] abstractFeatureArray, int n, boolean bl) {
        assert (Platform.isFxApplicationThread());
        if (n > 0) {
            Object object;
            int n2;
            int n3 = Math.addExact(this.validCount, n);
            if (n3 > this.elements.length) {
                this.elements = Arrays.copyOf(this.elements, Math.max(n3, this.elements.length << 1));
            }
            n3 = this.validCount;
            for (n2 = 0; n2 < n; ++n2) {
                object = abstractFeatureArray[n2];
                if (object == null) continue;
                this.elements[n3++] = object;
            }
            n2 = Math.min(n3, this.estimatedSize);
            object = Collections.nCopies(n2 - this.validCount, null);
            if (n3 >= this.estimatedSize) {
                this.estimatedSize = n3;
                if (bl) {
                    this.estimatedSize = (int)Math.min(0x7FFFFFFEL, (long)n3 + 10L);
                }
            }
            this.beginChange();
            this.nextReplace(this.validCount, n2, (List)object);
            this.validCount = n3;
            this.nextAdd(n2, n2 + this.validCount);
            this.endChange();
            this.checkOverflow();
        }
    }

    private void checkOverflow() {
        if (this.validCount >= 0x7FFFFFFE) {
            this.interrupt();
        }
    }

    final void setNextPage(FeatureLoader featureLoader) {
        assert (Platform.isFxApplicationThread());
        assert (this.nextPageLoader.isDone());
        this.nextPageLoader = featureLoader;
        if (featureLoader == null) {
            int n = this.estimatedSize - this.validCount;
            if (n != 0) {
                List<Object> list = Collections.nCopies(n, null);
                this.estimatedSize = this.validCount;
                this.beginChange();
                this.nextRemove(this.validCount, list);
                this.endChange();
            }
            this.isSizeExact = true;
            this.elements = ArraysExt.resize(this.elements, this.validCount);
        }
    }

    final boolean isCurrentLoader(FeatureLoader featureLoader) {
        return featureLoader == this.nextPageLoader;
    }

    public int size() {
        return this.estimatedSize;
    }

    public AbstractFeature get(int n) {
        assert (Platform.isFxApplicationThread());
        if (n < this.validCount) {
            return this.elements[n];
        }
        if (this.isSizeExact && n >= this.estimatedSize) {
            throw new IndexOutOfBoundsException(n);
        }
        FeatureLoader featureLoader = this.nextPageLoader;
        if (featureLoader != null && featureLoader.getState() == Worker.State.READY) {
            BackgroundThreads.execute((Runnable)((Object)featureLoader));
        }
        return null;
    }

    final void interrupt() {
        assert (Platform.isFxApplicationThread());
        FeatureLoader featureLoader = this.nextPageLoader;
        this.nextPageLoader = null;
        if (featureLoader != null) {
            featureLoader.cancel();
            BackgroundThreads.execute(featureLoader::waitAndClose);
        }
    }
}

