/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;

final class ExpandedFeature
extends AbstractFeature {
    private static final Object[] EMPTY = new Object[0];
    private final AbstractFeature source;
    private final Map<String, Integer> nameToIndex;
    private final Object[][] values;
    final int index;

    private ExpandedFeature(AbstractFeature abstractFeature, Map<String, Integer> map, Object[][] objectArray, int n) {
        super(abstractFeature.getType());
        this.source = abstractFeature;
        this.nameToIndex = map;
        this.values = objectArray;
        this.index = n;
    }

    static ExpandedFeature[] create(AbstractFeature abstractFeature, Map<String, Integer> map) {
        if (abstractFeature != null) {
            Object[][] objectArray = new Object[map.size()][];
            Arrays.fill((Object[])objectArray, EMPTY);
            int n = 0;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                int n2;
                Object object = abstractFeature.getPropertyValue(entry.getKey());
                if (object == null) continue;
                int n3 = entry.getValue();
                if (object instanceof Collection) {
                    Object[] objectArray2 = ((Collection)object).toArray();
                    if (objectArray2 != null) {
                        objectArray[n3] = objectArray2;
                    }
                } else {
                    objectArray[n3] = new Object[]{object};
                }
                if ((n2 = objectArray[n3].length) <= n) continue;
                n = n2;
            }
            if (n > 1) {
                ExpandedFeature[] expandedFeatureArray = new ExpandedFeature[n];
                for (int i = 0; i < n; ++i) {
                    expandedFeatureArray[i] = new ExpandedFeature(abstractFeature, map, objectArray, i);
                }
                return expandedFeatureArray;
            }
        }
        return null;
    }

    public DefaultFeatureType getType() {
        return this.source.getType();
    }

    public Object getProperty(String string) {
        return this.source.getProperty(string);
    }

    public void setProperty(Object object) {
        this.source.setProperty(object);
    }

    public Object getPropertyValue(String string) {
        Integer n = this.nameToIndex.get(string);
        if (n == null) {
            return this.source.getPropertyValue(string);
        }
        Object[] objectArray = this.values[n];
        return this.index < objectArray.length ? Collections.singletonList(objectArray[this.index]) : Collections.emptyList();
    }

    public Object getValueOrFallback(String string, Object object) {
        return this.getPropertyValue(string);
    }

    public void setPropertyValue(String string, Object object) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.source.hashCode() + this.index;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ExpandedFeature) {
            ExpandedFeature expandedFeature = (ExpandedFeature)((Object)object);
            return this.index == expandedFeature.index && this.source.equals((Object)expandedFeature.source);
        }
        return false;
    }

    public String toString() {
        return this.source.toString();
    }
}

