/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.control.Cell;
import javafx.scene.control.skin.CellSkinBase;
import javafx.scene.text.Text;
import org.apache.sis.gui.coverage.GridCell;
import org.apache.sis.gui.coverage.GridRow;
import org.apache.sis.gui.coverage.GridViewSkin;

final class GridRowSkin
extends CellSkinBase<GridRow> {
    GridRowSkin(GridRow gridRow) {
        super((Cell)gridRow);
        this.setRowIndex(gridRow.getIndex());
    }

    final void setRowIndex(int n) {
        Text text = (Text)this.getChildren().get(0);
        text.setText(((GridRow)this.getSkinnable()).view.formatHeaderValue(n, true));
    }

    protected void layoutChildren(double d, double d2, double d3, double d4) {
        ObservableList observableList = this.getChildren();
        GridRow gridRow = (GridRow)this.getSkinnable();
        GridViewSkin gridViewSkin = (GridViewSkin)gridRow.view.getSkin();
        double d5 = gridViewSkin.leftPosition;
        ((Text)observableList.get(0)).resizeRelocate(d5, d2, gridViewSkin.headerWidth, d4);
        d5 += gridViewSkin.headerWidth;
        double d6 = gridViewSkin.cellWidth;
        double d7 = gridViewSkin.cellInnerWidth;
        double d8 = gridViewSkin.rightPosition;
        int n = gridViewSkin.firstVisibleColumn;
        int n2 = 0;
        ArrayList<GridCell> arrayList = null;
        int n3 = observableList.size();
        while (d5 < d8) {
            GridCell gridCell;
            if (++n2 < n3) {
                gridCell = (GridCell)((Object)observableList.get(n2));
            } else {
                gridCell = new GridCell();
                gridCell.setAlignment(Pos.CENTER_RIGHT);
                if (arrayList == null) {
                    arrayList = new ArrayList<GridCell>(1 + (int)((d8 - d5) / d6));
                }
                arrayList.add(gridCell);
            }
            String string = gridRow.getSampleValue(n++);
            gridCell.updateItem(string, string == "");
            gridCell.resizeRelocate(d5, 0.0, d7, d4);
            d5 += d6;
        }
        if (arrayList != null) {
            observableList.addAll(arrayList);
        } else if (++n2 < n3) {
            observableList.remove(n2, n3);
        }
    }
}

