/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Locale;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Region;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.gui.Widget;
import org.apache.sis.gui.coverage.Controls;
import org.apache.sis.gui.coverage.CoverageControls;
import org.apache.sis.gui.coverage.GridControls;
import org.apache.sis.gui.coverage.GridView;
import org.apache.sis.gui.coverage.ImageRequest;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.internal.gui.NonNullObjectProperty;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.ToolbarButton;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.ReferenceSystem;

@DefaultProperty(value="coverage")
public class CoverageExplorer
extends Widget {
    public final ObjectProperty<GridCoverage> coverageProperty = new SimpleObjectProperty((Object)this, "coverage");
    public final ObjectProperty<View> viewTypeProperty = new NonNullObjectProperty<View>(this, "viewType", View.TABLE);
    private boolean isCoverageAdjusting;
    private SplitPane content;
    private final Controls[] views;
    private final RecentReferenceSystems referenceSystems;

    public CoverageExplorer() {
        this.coverageProperty.addListener((observableValue, gridCoverage, gridCoverage2) -> this.onCoverageSpecified((GridCoverage)gridCoverage2));
        this.referenceSystems = new RecentReferenceSystems();
        this.referenceSystems.addUserPreferences();
        this.referenceSystems.addAlternatives("EPSG:4326", "EPSG:3395");
        View[] viewArray = View.values();
        Vocabulary vocabulary = Vocabulary.getResources((Locale)null);
        this.views = new Controls[viewArray.length];
        for (View view : viewArray) {
            Controls controls;
            switch (view) {
                case TABLE: {
                    controls = new GridControls(this.referenceSystems, vocabulary);
                    break;
                }
                case IMAGE: {
                    controls = new CoverageControls(vocabulary, this.coverageProperty, this.referenceSystems);
                    break;
                }
                default: {
                    throw new AssertionError((Object)view);
                }
            }
            SplitPane.setResizableWithParent((Node)controls.controls(), (Boolean)Boolean.FALSE);
            SplitPane.setResizableWithParent((Node)controls.view(), (Boolean)Boolean.TRUE);
            this.views[view.ordinal()] = controls;
        }
    }

    @Override
    public final Region getView() {
        if (this.content == null) {
            Locale locale = null;
            ToggleGroup toggleGroup = new ToggleGroup();
            Control[] controlArray = new Control[this.views.length + 1];
            Resources resources = Resources.forLocale(locale);
            controlArray[0] = new Separator();
            for (View view3 : View.values()) {
                Controls controls = this.views[view3.ordinal()];
                controls.selector = new Selector(view3).createButton(toggleGroup, view3.icon, resources, view3.tooltip);
                controlArray[controlArray.length - view3.ordinal() - 1] = controls.selector;
            }
            Controls controls = this.views[0];
            toggleGroup.selectToggle((Toggle)toggleGroup.getToggles().get(0));
            this.content = new SplitPane(new Node[]{controls.controls(), controls.view()});
            ToolbarButton.insert((Node)this.content, controlArray);
            this.viewTypeProperty.addListener((observableValue, view, view2) -> this.onViewTypeSpecified((View)((Object)view2)));
            this.content.setDividerPosition(0, 1.0);
        }
        return this.content;
    }

    public final Region getDataView(View view) {
        ArgumentChecks.ensureNonNull("view", (Object)view);
        return this.views[view.ordinal()].view();
    }

    public final Region getControls(View view) {
        ArgumentChecks.ensureNonNull("view", (Object)view);
        return this.views[view.ordinal()].controls();
    }

    public final GridCoverage getCoverage() {
        return (GridCoverage)this.coverageProperty.get();
    }

    public final void setCoverage(GridCoverage gridCoverage) {
        this.coverageProperty.set((Object)gridCoverage);
    }

    public final void setCoverage(ImageRequest imageRequest) {
        if (imageRequest == null) {
            this.setCoverage((GridCoverage)null);
        } else {
            imageRequest.listener = this;
            this.startLoading(imageRequest);
        }
    }

    private void onCoverageSpecified(GridCoverage gridCoverage) {
        if (!this.isCoverageAdjusting) {
            this.startLoading(null);
            this.notifyCoverageChange(gridCoverage, null);
            if (gridCoverage != null) {
                this.startLoading(new ImageRequest(gridCoverage, null));
            }
        }
    }

    final void onCoverageLoaded(GridCoverage gridCoverage, Resource resource) {
        this.notifyCoverageChange(gridCoverage, (Reference<Resource>)(resource != null ? new WeakReference<Resource>(resource) : null));
        this.isCoverageAdjusting = true;
        try {
            this.setCoverage(gridCoverage);
        }
        finally {
            this.isCoverageAdjusting = false;
        }
    }

    private void startLoading(ImageRequest imageRequest) {
        GridView gridView = (GridView)this.views[View.TABLE.ordinal()].view();
        gridView.setImage(imageRequest);
    }

    private void notifyCoverageChange(GridCoverage gridCoverage, Reference<Resource> reference) {
        if (gridCoverage != null) {
            Controls[] controlsArray = gridCoverage.getGridGeometry();
            this.referenceSystems.areaOfInterest.set((Object)(controlsArray.isDefined(2) ? controlsArray.getEnvelope() : null));
            if (controlsArray.isDefined(1)) {
                this.referenceSystems.setPreferred(true, (ReferenceSystem)controlsArray.getCoordinateReferenceSystem());
            }
        }
        for (Controls controls : this.views) {
            controls.coverageChanged(gridCoverage, reference);
        }
    }

    public final View getViewType() {
        return (View)((Object)this.viewTypeProperty.get());
    }

    public final void setViewType(View view) {
        this.viewTypeProperty.set((Object)view);
    }

    private void onViewTypeSpecified(View view) {
        Controls controls = this.views[view.ordinal()];
        this.content.getItems().setAll((Object[])new Node[]{controls.controls(), controls.view()});
        ((Toggle)controls.selector).setSelected(true);
    }

    public static enum View {
        TABLE("\ud83d\udd22\ufe0f", 34),
        IMAGE("\ud83d\uddfa\ufe0f", 33);

        final String icon;
        final short tooltip;

        private View(String string2, short s) {
            this.icon = string2;
            this.tooltip = s;
        }
    }

    private final class Selector
    extends ToolbarButton {
        private final View view;

        Selector(View view) {
            this.view = view;
        }

        @Override
        public void handle(ActionEvent actionEvent) {
            Toggle toggle = (Toggle)actionEvent.getSource();
            if (toggle.isSelected()) {
                CoverageExplorer.this.setViewType(this.view);
            } else {
                toggle.setSelected(true);
            }
        }
    }
}

