/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.lang.ref.Reference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.StringConverter;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.gui.coverage.Controls;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.gui.coverage.CoverageStyling;
import org.apache.sis.gui.coverage.ImagePropertyExplorer;
import org.apache.sis.gui.coverage.IsolineRenderer;
import org.apache.sis.gui.coverage.Stretching;
import org.apache.sis.gui.map.MapMenu;
import org.apache.sis.gui.map.StatusBar;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.image.Interpolation;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.gui.control.ValueColorMapper;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.resources.Vocabulary;

final class CoverageControls
extends Controls {
    private final CoverageCanvas view;
    private final TableView<Category> categoryTable;
    private final IsolineRenderer isolines;
    private final Accordion controls;
    private final BorderPane imageAndStatus;

    CoverageControls(Vocabulary vocabulary, ObjectProperty<GridCoverage> objectProperty, RecentReferenceSystems recentReferenceSystems) {
        StatusBar statusBar;
        Resources resources = Resources.forLocale(vocabulary.getLocale());
        this.view = new CoverageCanvas(vocabulary.getLocale());
        this.view.setBackground(Color.BLACK);
        this.view.statusBar = statusBar = new StatusBar(recentReferenceSystems, this.view);
        this.imageAndStatus = new BorderPane((Node)this.view.getView());
        this.imageAndStatus.setBottom((Node)statusBar.getView());
        MapMenu mapMenu = new MapMenu(this.view);
        mapMenu.addReferenceSystems(recentReferenceSystems);
        mapMenu.addCopyOptions(statusBar);
        Label label = new Label();
        Object object = CoverageControls.labelOfGroup(vocabulary, (short)168, (Region)label, true);
        label.setPadding(CONTENT_MARGIN);
        label.setTooltip(new Tooltip(resources.getString((short)49)));
        mapMenu.selectedReferenceSystem().ifPresent(observableObjectValue -> label.textProperty().bind((ObservableValue)observableObjectValue));
        Object object2 = Styles.createControlGrid(0, CoverageControls.label(vocabulary, (short)231, this.createInterpolationButton(vocabulary.getLocale())));
        Label label2 = CoverageControls.labelOfGroup(vocabulary, (short)216, (Region)object2, false);
        VBox vBox = new VBox(new Node[]{object, label, label2, object2});
        object = new CoverageStyling(this.view);
        this.categoryTable = ((CoverageStyling)object).createCategoryTable(vocabulary);
        object2 = Styles.createControlGrid(0, CoverageControls.label(vocabulary, (short)229, Stretching.createButton((ChangeListener<Stretching>)((ChangeListener)(observableValue, stretching, stretching2) -> this.view.setStyling((Stretching)((Object)stretching2))))));
        label = new VBox(new Node[]{CoverageControls.labelOfGroup(vocabulary, (short)248, this.categoryTable, true), this.categoryTable, object2});
        object2 = new ValueColorMapper(resources, vocabulary);
        this.isolines = new IsolineRenderer(this.view);
        this.isolines.setIsolineTables(Collections.singletonList(((ValueColorMapper)object2).getSteps()));
        object = new VBox(new Node[]{((ValueColorMapper)object2).getView()});
        object2 = new TitledPane(vocabulary.getString((short)184), (Node)vBox);
        label2 = new TitledPane(vocabulary.getString((short)228), (Node)label);
        TitledPane titledPane = new TitledPane(vocabulary.getString((short)252), (Node)object);
        TitledPane titledPane2 = new TitledPane(vocabulary.getString((short)237), null);
        this.controls = new Accordion(new TitledPane[]{object2, label2, titledPane, titledPane2});
        this.controls.setExpandedPane((TitledPane)object2);
        this.view.coverageProperty.bind(objectProperty);
        titledPane2.expandedProperty().addListener((ChangeListener)new PropertyPaneCreator(this.view, titledPane2));
    }

    private ChoiceBox<Interpolation> createInterpolationButton(Locale locale) {
        ChoiceBox choiceBox = new ChoiceBox();
        choiceBox.setConverter((StringConverter)new InterpolationConverter(locale));
        choiceBox.getItems().setAll((Object[])InterpolationConverter.INTERPOLATIONS);
        choiceBox.getSelectionModel().select((Object)this.view.getInterpolation());
        this.view.interpolationProperty.bind((ObservableValue)choiceBox.getSelectionModel().selectedItemProperty());
        return choiceBox;
    }

    @Override
    final void coverageChanged(GridCoverage gridCoverage, Reference<Resource> reference) {
        this.view.setOriginator(reference);
        if (gridCoverage != null) {
            List list = gridCoverage.getSampleDimensions();
            this.categoryTable.getItems().setAll((Collection)((SampleDimension)list.get(0)).getCategories());
        } else {
            this.categoryTable.getItems().clear();
        }
    }

    @Override
    final Region view() {
        return this.imageAndStatus;
    }

    @Override
    final Control controls() {
        return this.controls;
    }

    private static final class PropertyPaneCreator
    implements ChangeListener<Boolean> {
        private final CoverageCanvas view;
        private final TitledPane pane;

        PropertyPaneCreator(CoverageCanvas coverageCanvas, TitledPane titledPane) {
            this.view = coverageCanvas;
            this.pane = titledPane;
        }

        public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
            if (bl2.booleanValue()) {
                this.pane.expandedProperty().removeListener((ChangeListener)this);
                ImagePropertyExplorer imagePropertyExplorer = this.view.createPropertyExplorer();
                imagePropertyExplorer.updateOnChange.bind((ObservableValue)this.pane.expandedProperty());
                this.pane.setContent((Node)imagePropertyExplorer.getView());
            }
        }
    }

    private static final class InterpolationConverter
    extends StringConverter<Interpolation> {
        static final Interpolation[] INTERPOLATIONS = new Interpolation[]{Interpolation.NEAREST, Interpolation.BILINEAR, Interpolation.LANCZOS};
        private static final short[] VOCABULARIES = new short[]{232, 230, 0};
        private final Locale locale;

        InterpolationConverter(Locale locale) {
            this.locale = locale;
        }

        public String toString(Interpolation interpolation) {
            for (int i = 0; i < INTERPOLATIONS.length; ++i) {
                if (!INTERPOLATIONS[i].equals(interpolation)) continue;
                short s = VOCABULARIES[i];
                if (s != 0) {
                    return Vocabulary.getResources(this.locale).getString(s);
                }
                if (interpolation != Interpolation.LANCZOS) continue;
                return "Lanczos";
            }
            return Objects.toString(interpolation);
        }

        public Interpolation fromString(String string) {
            Vocabulary vocabulary = Vocabulary.getResources(this.locale);
            for (int i = 0; i < VOCABULARIES.length; ++i) {
                short s = VOCABULARIES[i];
                Interpolation interpolation = INTERPOLATIONS[i];
                if ((s == 0 || !vocabulary.getString(s).equalsIgnoreCase(string)) && !interpolation.toString().equalsIgnoreCase(string)) continue;
                return interpolation;
            }
            return null;
        }
    }
}

