/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.lang.ref.Reference;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.resources.IndexedResourceBundle;

abstract class Controls {
    private static final Insets CAPTION_MARGIN = new Insets(12.0, 0.0, 6.0, 0.0);
    private static final Insets NEXT_CAPTION_MARGIN = new Insets(30.0, 0.0, 6.0, 0.0);
    static final Insets CONTENT_MARGIN = new Insets(0.0, 0.0, 0.0, Styles.FORM_INSETS.getLeft());
    ButtonBase selector;

    Controls() {
    }

    static Label label(IndexedResourceBundle indexedResourceBundle, short s, Control control) {
        if (control == null) {
            return null;
        }
        control.setMaxWidth(Double.POSITIVE_INFINITY);
        Label label = new Label(indexedResourceBundle.getLabel(s));
        label.setLabelFor((Node)control);
        return label;
    }

    static Label labelOfGroup(IndexedResourceBundle indexedResourceBundle, short s, Region region, boolean bl) {
        Label label = new Label(indexedResourceBundle.getString(s));
        label.setPadding(bl ? CAPTION_MARGIN : NEXT_CAPTION_MARGIN);
        label.setLabelFor((Node)region);
        label.setFont(Controls.fontOfGroup());
        return label;
    }

    static Font fontOfGroup() {
        return Font.font(null, (FontWeight)FontWeight.BOLD, (double)-1.0);
    }

    abstract Region view();

    abstract Control controls();

    abstract void coverageChanged(GridCoverage var1, Reference<Resource> var2);
}

