/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.StringJoiner;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import org.apache.sis.gui.dataset.LoadEvent;
import org.apache.sis.gui.dataset.ResourceExplorer;
import org.apache.sis.internal.gui.RecentChoices;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.util.ArraysExt;

final class RecentFiles
implements EventHandler<ActionEvent> {
    private static final int MAX_COUNT = 10;
    private final ObservableList<MenuItem> items;
    private final ResourceExplorer explorer;

    private RecentFiles(ResourceExplorer resourceExplorer, Menu menu) {
        this.explorer = resourceExplorer;
        this.items = menu.getItems();
    }

    static Menu create(ResourceExplorer resourceExplorer, Resources resources) {
        Menu menu = new Menu(resources.getString((short)54));
        RecentFiles recentFiles = new RecentFiles(resourceExplorer, menu);
        CharSequence[] charSequenceArray = RecentChoices.getFiles();
        MenuItem[] menuItemArray = new MenuItem[charSequenceArray.length];
        int n = 0;
        for (int i = 0; i < charSequenceArray.length; ++i) {
            String string = charSequenceArray[i].toString();
            if (string.isBlank()) continue;
            menuItemArray[n++] = recentFiles.createItem(new File(string));
        }
        recentFiles.items.setAll((Object[])ArraysExt.resize(menuItemArray, n));
        resourceExplorer.setOnResourceLoaded((EventHandler<LoadEvent>)((EventHandler)recentFiles::opened));
        return menu;
    }

    private MenuItem createItem(File file) {
        MenuItem menuItem = new MenuItem(file.getName());
        menuItem.setUserData((Object)file);
        menuItem.setOnAction((EventHandler)this);
        return menuItem;
    }

    public void opened(LoadEvent loadEvent) {
        File file;
        Path path = loadEvent.getResourcePath();
        try {
            file = path.toFile();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return;
        }
        int n = this.items.size();
        MenuItem menuItem = null;
        for (int i = 0; i < n; ++i) {
            if (!file.equals(((MenuItem)this.items.get(i)).getUserData())) continue;
            menuItem = (MenuItem)this.items.remove(i);
            break;
        }
        if (menuItem == null) {
            if (n >= 10) {
                menuItem = (MenuItem)this.items.remove(n - 1);
                menuItem.setText(file.getName());
                menuItem.setUserData((Object)file);
            } else {
                menuItem = this.createItem(file);
            }
        }
        this.items.add(0, menuItem);
        StringJoiner stringJoiner = new StringJoiner(System.lineSeparator());
        for (MenuItem menuItem2 : this.items) {
            stringJoiner.add(((File)menuItem2.getUserData()).getPath());
        }
        RecentChoices.setFiles(stringJoiner.toString());
    }

    public void handle(ActionEvent actionEvent) {
        Object object = ((MenuItem)actionEvent.getSource()).getUserData();
        this.explorer.loadResources(Collections.singleton(object));
    }
}

