/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.EnumSet;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.storage.DataStores;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

final class MimeTypeCommand
extends CommandRunner {
    MimeTypeCommand(int n, String ... stringArray) throws InvalidOptionException {
        super(n, stringArray, EnumSet.of(Option.ENCODING, Option.HELP, Option.DEBUG));
    }

    @Override
    public int run() throws Exception {
        if (this.hasUnexpectedFileCount(1, Integer.MAX_VALUE)) {
            return 3;
        }
        int n = 0;
        for (String string : this.files) {
            int n2 = string.length() + 1;
            if (n2 <= n) continue;
            n = n2;
        }
        for (String string : this.files) {
            String string2;
            URI uRI;
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.canNotOpen(0, uRISyntaxException);
                return 100;
            }
            if (!uRI.isAbsolute()) {
                string2 = DataStores.probeContentType((Object)string);
            } else {
                try {
                    string2 = Files.probeContentType(Paths.get(uRI));
                }
                catch (IllegalArgumentException | FileSystemNotFoundException runtimeException) {
                    string2 = DataStores.probeContentType((Object)uRI);
                }
                catch (NoSuchFileException noSuchFileException) {
                    this.error(Errors.format((short)9, (Object)uRI), noSuchFileException);
                    return 100;
                }
            }
            if (string2 == null) continue;
            this.out.print(string);
            this.out.print(':');
            this.out.print(CharSequences.spaces((int)(n - string.length())));
            this.out.println(string2);
            this.out.flush();
        }
        return 0;
    }
}

