/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.util.Collections;
import java.util.EnumSet;
import java.util.function.Predicate;
import org.apache.sis.console.FormattedOutputCommand;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.console.OutputFormat;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.ReferenceSystem;

final class MetadataCommand
extends FormattedOutputCommand {
    static EnumSet<Option> options() {
        return EnumSet.of(Option.FORMAT, new Option[]{Option.LOCALE, Option.TIMEZONE, Option.ENCODING, Option.COLORS, Option.VERBOSE, Option.HELP, Option.DEBUG});
    }

    MetadataCommand(int n, String ... stringArray) throws InvalidOptionException {
        super(n, stringArray, MetadataCommand.options(), OutputFormat.TEXT, OutputFormat.XML, OutputFormat.GPX);
    }

    @Override
    public int run() throws Exception {
        Object object = this.readMetadataOrCRS();
        if (this.hasUnexpectedFileCount) {
            return 3;
        }
        if (object != null) {
            if (!(object instanceof Metadata)) {
                DefaultMetadata defaultMetadata = new DefaultMetadata();
                defaultMetadata.setReferenceSystemInfo(Collections.singleton((ReferenceSystem)object));
                object = defaultMetadata;
            }
            this.format(object);
        }
        return 0;
    }

    @Override
    Predicate<TreeTable.Node> getNodeFilter() {
        if (this.options.containsKey((Object)Option.VERBOSE)) {
            return null;
        }
        return node -> !"metadataStandard".equals(node.getValue(TableColumn.IDENTIFIER));
    }
}

