/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.samza.serializers


import org.junit.Assert._
import org.junit.Test

import scala.collection.JavaConverters._


class TestJsonSerdeV2 {
  @Test
  def testJsonSerdeV2ShouldWork {
    val serde = new JsonSerdeV2[java.util.HashMap[String, Object]]
    val obj = new java.util.HashMap[String, Object](Map[String, Object]("hi" -> "bye", "why" -> new java.lang.Integer(2)).asJava)
    val bytes = serde.toBytes(obj)
    assertEquals(obj, serde.fromBytes(bytes))
    val serdeHashMapEntry = new JsonSerdeV2[java.util.Map.Entry[String, Object]]
    obj.entrySet().asScala.foreach(entry => {
      try {
        val entryBytes = serdeHashMapEntry.toBytes(entry)
      } catch {
        case e: Exception => fail("HashMap Entry serialization failed!")
      }
    })
  }
}
