/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.reef.wake.time;

/**
 * Time object.
 */
public abstract class Time implements Comparable<Time> {

  private final long timestamp;

  public Time(final long timestamp) {
    this.timestamp = timestamp;
  }

  public final long getTimeStamp() {
    return this.timestamp;
  }

  @Override
  public final String toString() {
    return this.getClass().getName() + "[" + this.timestamp + "]";
  }

  @Override
  public final int compareTo(final Time o) {
    if (this.timestamp < o.timestamp) {
      return -1;
    }
    if (this.timestamp > o.timestamp) {
      return 1;
    }
    if (this.hashCode() < o.hashCode()) {
      return -1;
    }
    if (this.hashCode() > o.hashCode()) {
      return 1;
    }
    return 0;
  }

  @Override
  public final boolean equals(final Object o) {
    if (o instanceof Time) {
      return compareTo((Time) o) == 0;
    }
    return false;
  }

  @Override
  public final int hashCode() {
    return super.hashCode();
  }
}
