/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.reef.tang.test;

import org.apache.reef.tang.annotations.Parameter;

import javax.inject.Inject;
import java.util.List;

public class ListOfImplementations {

  private final List<ListInterface> theInstances;

  @Inject
  ListOfImplementations(@Parameter(TestConfiguration.ListOfInstances.class) final List<ListInterface> theInstances) {
    this.theInstances = theInstances;
  }

  @Override
  public boolean equals(final Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    final ListOfImplementations that = (ListOfImplementations) o;

    if (!theInstances.equals(that.theInstances)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    return theInstances.hashCode();
  }

  public boolean isValid() {
    return this.theInstances.size() == 2;
  }
}
