/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.reef.runtime.local.driver;


/**
 * Generates unique IDs.
 */
public final class IDMaker {

  private final String prefix;
  private int counter = 0;

  /**
   * The ids generated by getNextID are of the form "prefixNUMBER", where
   * number is counted up.
   *
   * @param prefix a prefix to be used for the IDs generated.
   */
  public IDMaker(final String prefix) {
    this.prefix = prefix;
  }

  /**
   * @return the next ID
   */
  public String getNextID() {
    this.counter += 1;
    return this.prefix + this.counter;
  }
}
