/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.reef.io.network.util;

import org.apache.reef.wake.ComparableIdentifier;
import org.apache.reef.wake.Identifier;
import org.apache.reef.wake.IdentifierFactory;
import org.junit.Test;

import java.util.List;

/**
 * Tests for REEF IO network utilities.
 */
public class UtilsTest {

  /**
   * Generic parseList test.
   */
  @Test
  public void testParseList() {
    final IdentifierFactory factory = new StringIdentifierFactory();

    final List<Identifier> list1 = Utils.parseList("1,2,3", factory);
    final List<ComparableIdentifier> list2 = Utils.parseList("1,2,3", factory);
  }
}
