/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.reef.io.network.util;

import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggingUtils {
  public static void setLoggingLevel(final Level level) {
    final Handler[] handlers = Logger.getLogger("").getHandlers();
    ConsoleHandler ch = null;
    for (final Handler h : handlers) {
      if (h instanceof ConsoleHandler) {
        ch = (ConsoleHandler) h;
        break;
      }
    }
    if (ch == null) {
      ch = new ConsoleHandler();
      Logger.getLogger("").addHandler(ch);
    }
    ch.setLevel(level);
    Logger.getLogger("").setLevel(level);
  }

  /**
   * Empty private constructor to prohibit instantiation of utility class.
   */
  private LoggingUtils() {
  }
}
