/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.reef.driver.evaluator;

import org.junit.Test;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

/**
 * Tests for JVMProcess.
 */
public final class JVMProcessTest {

  @Test
  public void testIsOptionSetFalse() {
    final JVMProcess jvmProcess = new JVMProcess(null, null);
    assertFalse("Option not set", jvmProcess.isOptionSet());
  }

  @Test
  public void testIsOptionSet() {
    final JVMProcess jvmProcess = new JVMProcess(null, null)
        .addOption("-XX:+HeapDumpOnOutOfMemory");
    assertTrue("Option set", jvmProcess.isOptionSet());
  }

  @Test
  public void testIsOptionSetOnMemory() {
    final JVMProcess jvmProcess = new JVMProcess(null, null)
        .setMemory(500);
    assertTrue("Option set", jvmProcess.isOptionSet());
  }
}
