/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.reef.runtime.common.evaluator;

import javax.inject.Inject;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Default implementation for re-establishing connection to driver after driver restart.
 * In this default implementation, information about re-started driver will be obtained
 * by querying Http server.
 */
public final class DefaultDriverConnection implements DriverConnection {

  private static final Logger LOG = Logger.getLogger(DefaultDriverConnection.class.getName());

  @Inject
  public DefaultDriverConnection() {
  }

  @Override
  public String getDriverRemoteIdentifier() {
    LOG.log(Level.FINE, "Trying to get driver remote identifier by querying Http server.");
    // TODO[JIRA REEF-843]: implement a proper mechanism to obtain driver remote identifier.
    throw new UnsupportedOperationException("Not implemented");
  }

  @Override
  public void close() {
  }
}
