﻿// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

using System;
using System.Net;
using Org.Apache.REEF.Wake.Remote.Impl;

namespace Org.Apache.REEF.Wake.Remote
{
    public interface IRemoteManager<T> : IStage
    {
        IRemoteIdentifier Identifier { get; }

        IPEndPoint LocalEndpoint { get; }

        IObserver<T> GetRemoteObserver(RemoteEventEndPoint<T> dest);

        IObserver<T> GetRemoteObserver(IPEndPoint remoteEndpoint);

        IRemoteObserver<T> GetUnmanagedRemoteObserver(RemoteEventEndPoint<T> dest);

        IRemoteObserver<T> GetUnmanagedObserver(IPEndPoint remoteEndpoint);

        IDisposable RegisterObserver(RemoteEventEndPoint<T> source, IObserver<T> theObserver);

        IDisposable RegisterObserver(IPEndPoint remoteEndpoint, IObserver<T> theObserver);

        IDisposable RegisterObserver(IObserver<IRemoteMessage<T>> theObserver);
    }
}
