// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

//<auto-generated />
namespace Org.Apache.REEF.Tang.Implementations.ClassHierarchy.AvroDataContract
{
    using System;
    using System.Collections.Generic;
    using System.Runtime.Serialization;
    using Microsoft.Hadoop.Avro;

    /// <summary>
    /// Used to serialize and deserialize Avro record org.apache.reef.tang.implementation.avro.AvroNode.
    /// </summary>
    [DataContract(Namespace = "org.apache.reef.tang.implementation.avro")]
    [KnownType(typeof(List<Org.Apache.REEF.Tang.Implementations.ClassHierarchy.AvroDataContract.AvroNode>))]
    public partial class AvroNode
    {
        private const string JsonSchema = @"{""type"":""record"",""name"":""org.apache.reef.tang.implementation.avro.AvroNode"",""fields"":[{""name"":""name"",""type"":""string""},{""name"":""fullName"",""type"":""string""},{""name"":""classNode"",""type"":[""null"",{""type"":""record"",""name"":""org.apache.reef.tang.implementation.avro.AvroClassNode"",""fields"":[{""name"":""isInjectionCandidate"",""type"":""boolean""},{""name"":""isExternalConstructor"",""type"":""boolean""},{""name"":""isUnit"",""type"":""boolean""},{""name"":""injectableConstructors"",""type"":{""type"":""array"",""items"":{""type"":""record"",""name"":""org.apache.reef.tang.implementation.avro.AvroConstructorDef"",""fields"":[{""name"":""fullClassName"",""type"":""string""},{""name"":""constructorArgs"",""type"":{""type"":""array"",""items"":{""type"":""record"",""name"":""org.apache.reef.tang.implementation.avro.AvroConstructorArg"",""fields"":[{""name"":""fullArgClassName"",""type"":""string""},{""name"":""namedParameterName"",""type"":[""null"",""string""]},{""name"":""isInjectionFuture"",""type"":""boolean""}]}}}]}}},{""name"":""otherConstructors"",""type"":{""type"":""array"",""items"":""org.apache.reef.tang.implementation.avro.AvroConstructorDef""}},{""name"":""implFullNames"",""type"":{""type"":""array"",""items"":""string""}},{""name"":""defaultImplementation"",""type"":[""null"",""string""]}]}]},{""name"":""namedParameterNode"",""type"":[""null"",{""type"":""record"",""name"":""org.apache.reef.tang.implementation.avro.AvroNamedParameterNode"",""fields"":[{""name"":""simpleArgClassName"",""type"":""string""},{""name"":""fullArgClassName"",""type"":""string""},{""name"":""isSet"",""type"":""boolean""},{""name"":""isList"",""type"":""boolean""},{""name"":""documentation"",""type"":[""null"",""string""]},{""name"":""shortName"",""type"":[""null"",""string""]},{""name"":""instanceDefault"",""type"":{""type"":""array"",""items"":""string""}}]}]},{""name"":""packageNode"",""type"":[""null"",{""type"":""record"",""name"":""org.apache.reef.tang.implementation.avro.AvroPackageNode"",""fields"":[]}]},{""name"":""children"",""type"":{""type"":""array"",""items"":""org.apache.reef.tang.implementation.avro.AvroNode""}}]}";

        /// <summary>
        /// Gets the schema.
        /// </summary>
        public static string Schema
        {
            get
            {
                return JsonSchema;
            }
        }
      
        /// <summary>
        /// Gets or sets the name field.
        /// </summary>
        [DataMember]
        public string name { get; set; }
              
        /// <summary>
        /// Gets or sets the fullName field.
        /// </summary>
        [DataMember]
        public string fullName { get; set; }
              
        /// <summary>
        /// Gets or sets the classNode field.
        /// </summary>
        [DataMember]
        [AvroUnion(typeof(AvroNull), typeof(Org.Apache.REEF.Tang.Implementations.ClassHierarchy.AvroDataContract.AvroClassNode))]
        public object classNode { get; set; }
              
        /// <summary>
        /// Gets or sets the namedParameterNode field.
        /// </summary>
        [DataMember]
        [AvroUnion(typeof(AvroNull), typeof(Org.Apache.REEF.Tang.Implementations.ClassHierarchy.AvroDataContract.AvroNamedParameterNode))]
        public object namedParameterNode { get; set; }
              
        /// <summary>
        /// Gets or sets the packageNode field.
        /// </summary>
        [DataMember]
        [AvroUnion(typeof(AvroNull), typeof(Org.Apache.REEF.Tang.Implementations.ClassHierarchy.AvroDataContract.AvroPackageNode))]
        public object packageNode { get; set; }
              
        /// <summary>
        /// Gets or sets the children field.
        /// </summary>
        [DataMember]
        public List<Org.Apache.REEF.Tang.Implementations.ClassHierarchy.AvroDataContract.AvroNode> children { get; set; }
                
        /// <summary>
        /// Initializes a new instance of the <see cref="AvroNode"/> class.
        /// </summary>
        public AvroNode()
        {
            this.classNode = null;
            this.namedParameterNode = null;
            this.packageNode = null;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AvroNode"/> class.
        /// </summary>
        /// <param name="name">The name.</param>
        /// <param name="fullName">The fullName.</param>
        /// <param name="classNode">The classNode.</param>
        /// <param name="namedParameterNode">The namedParameterNode.</param>
        /// <param name="packageNode">The packageNode.</param>
        /// <param name="children">The children.</param>
        public AvroNode(string name, string fullName, object classNode, object namedParameterNode, object packageNode, List<Org.Apache.REEF.Tang.Implementations.ClassHierarchy.AvroDataContract.AvroNode> children)
        {
            this.name = name;
            this.fullName = fullName;
            this.classNode = classNode;
            this.namedParameterNode = namedParameterNode;
            this.packageNode = packageNode;
            this.children = children;
        }
    }
}