// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

//<auto-generated />
namespace Org.Apache.REEF.Tang.Implementations.ClassHierarchy.AvroDataContract
{
    using System;
    using System.Collections.Generic;
    using System.Runtime.Serialization;
    using Microsoft.Hadoop.Avro;

    /// <summary>
    /// Used to serialize and deserialize Avro record org.apache.reef.tang.implementation.avro.AvroConstructorDef.
    /// </summary>
    [DataContract(Namespace = "org.apache.reef.tang.implementation.avro")]
    [KnownType(typeof(List<Org.Apache.REEF.Tang.Implementations.ClassHierarchy.AvroDataContract.AvroConstructorArg>))]
    public partial class AvroConstructorDef
    {
        private const string JsonSchema = @"{""type"":""record"",""name"":""org.apache.reef.tang.implementation.avro.AvroConstructorDef"",""fields"":[{""name"":""fullClassName"",""type"":""string""},{""name"":""constructorArgs"",""type"":{""type"":""array"",""items"":{""type"":""record"",""name"":""org.apache.reef.tang.implementation.avro.AvroConstructorArg"",""fields"":[{""name"":""fullArgClassName"",""type"":""string""},{""name"":""namedParameterName"",""type"":[""null"",""string""]},{""name"":""isInjectionFuture"",""type"":""boolean""}]}}}]}";

        /// <summary>
        /// Gets the schema.
        /// </summary>
        public static string Schema
        {
            get
            {
                return JsonSchema;
            }
        }
      
        /// <summary>
        /// Gets or sets the fullClassName field.
        /// </summary>
        [DataMember]
        public string fullClassName { get; set; }
              
        /// <summary>
        /// Gets or sets the constructorArgs field.
        /// </summary>
        [DataMember]
        public List<Org.Apache.REEF.Tang.Implementations.ClassHierarchy.AvroDataContract.AvroConstructorArg> constructorArgs { get; set; }
                
        /// <summary>
        /// Initializes a new instance of the <see cref="AvroConstructorDef"/> class.
        /// </summary>
        public AvroConstructorDef()
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AvroConstructorDef"/> class.
        /// </summary>
        /// <param name="fullClassName">The fullClassName.</param>
        /// <param name="constructorArgs">The constructorArgs.</param>
        public AvroConstructorDef(string fullClassName, List<Org.Apache.REEF.Tang.Implementations.ClassHierarchy.AvroDataContract.AvroConstructorArg> constructorArgs)
        {
            this.fullClassName = fullClassName;
            this.constructorArgs = constructorArgs;
        }
    }
}