﻿// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

using Org.Apache.REEF.Tang.Formats;
using Org.Apache.REEF.Tang.Formats.AvroConfigurationDataContract;
using Org.Apache.REEF.Tang.Interface;
using Org.Apache.REEF.Tang.Tests.SmokeTest;

namespace Org.Apache.REEF.Tang.Tests.Configuration
{
    public class TestAvroSerializerRoundTrip
    {
        public class AvroConfigurationTest : RoundTripTest
        {
            public override IConfiguration RoundTrip(IConfiguration configuration)
            {
                AvroConfiguration aConf = new AvroConfigurationSerializer().ToAvroConfiguration(configuration);
                return new AvroConfigurationSerializer().FromAvro(aConf);
            }
        }

        public class ByteArrayTest : RoundTripTest
        {
            public override IConfiguration RoundTrip(IConfiguration configuration)
            {
                AvroConfigurationSerializer serializer = new AvroConfigurationSerializer();
                byte[] theBytes = serializer.ToByteArray(configuration);
                return serializer.FromByteArray(theBytes);
            }
        }

        public class FileTest : RoundTripTest
        {
            public override IConfiguration RoundTrip(IConfiguration configuration)
            {
                AvroConfigurationSerializer serializer = new AvroConfigurationSerializer();
                serializer.ToFile(configuration, "TangTest.avroconf");
                return serializer.FromFile("TangTest.avroconf");
            }
        }

        public class StringTest : RoundTripTest
        {
            public override IConfiguration RoundTrip(IConfiguration configuration)
            {
                AvroConfigurationSerializer serializer = new AvroConfigurationSerializer();
                return serializer.FromString(serializer.ToString(configuration));
            }
        }
    }
}