﻿// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

using System;
using System.Collections.Generic;
using Org.Apache.REEF.Common.Context.Defaults;
using Org.Apache.REEF.Common.Events;
using Org.Apache.REEF.Tang.Annotations;
using Org.Apache.REEF.Utilities.Attributes;

namespace Org.Apache.REEF.Common.Context
{
    /// <summary>
    ///  Configuration parameters for ContextConfiguration module.
    /// </summary>
    [ClientSide]
    public static class ContextConfigurationOptions
    {
        [NamedParameter(documentation: "The identifier for the context.")]
        public class ContextIdentifier : Name<string>
        {
        }

        [NamedParameter(documentation: "The set of event handlers for the ContextStart event", defaultClasses: new[] { typeof(DefaultContextStartHandler) })]
        public class StartHandlers : Name<ISet<IObserver<IContextStart>>>
        {
        }

        [NamedParameter(documentation: "The set of event handlers for the ContextStop event", defaultClasses: new[] { typeof(DefaultContextStopHandler) })]
        public class StopHandlers : Name<ISet<IObserver<IContextStop>>>
        {
        }

        [NamedParameter(documentation: "The set of ContextMessageSource implementations called during heartbeats.", defaultClasses: new[] { typeof(DefaultContextMessageSource) })]
        public class ContextMessageSources : Name<ISet<IContextMessageSource>>
        {
        }

        [NamedParameter(documentation: "The set of Context message handlers.")]
        public class ContextMessageHandlers : Name<ISet<IContextMessageHandler>>
        {
        }
    }
}
