/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import org.apache.pdfbox.debugger.ui.MenuBase;

public final class RotationMenu
extends MenuBase {
    public static final String ROTATE_0_DEGREES = "0\u00b0";
    public static final String ROTATE_90_DEGREES = "90\u00b0";
    public static final String ROTATE_180_DEGREES = "180\u00b0";
    public static final String ROTATE_270_DEGREES = "270\u00b0";
    private static RotationMenu instance;
    private JRadioButtonMenuItem rotate0Item;
    private JRadioButtonMenuItem rotate90Item;
    private JRadioButtonMenuItem rotate180Item;
    private JRadioButtonMenuItem rotate270Item;

    private RotationMenu() {
        this.setMenu(this.createRotationMenu());
    }

    public static RotationMenu getInstance() {
        if (instance == null) {
            instance = new RotationMenu();
        }
        return instance;
    }

    public void setRotationSelection(String selection) {
        if (ROTATE_0_DEGREES.equals(selection)) {
            this.rotate0Item.setSelected(true);
        } else if (ROTATE_90_DEGREES.equals(selection)) {
            this.rotate90Item.setSelected(true);
        } else if (ROTATE_180_DEGREES.equals(selection)) {
            this.rotate180Item.setSelected(true);
        } else if (ROTATE_270_DEGREES.equals(selection)) {
            this.rotate270Item.setSelected(true);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static boolean isRotationMenu(String actionCommand) {
        return ROTATE_0_DEGREES.equals(actionCommand) || ROTATE_90_DEGREES.equals(actionCommand) || ROTATE_180_DEGREES.equals(actionCommand) || ROTATE_270_DEGREES.equals(actionCommand);
    }

    public static int getRotationDegrees() {
        if (RotationMenu.instance.rotate90Item.isSelected()) {
            return 90;
        }
        if (RotationMenu.instance.rotate180Item.isSelected()) {
            return 180;
        }
        if (RotationMenu.instance.rotate270Item.isSelected()) {
            return 270;
        }
        return 0;
    }

    public static int getRotationDegrees(String actionCommand) {
        if (ROTATE_0_DEGREES.equals(actionCommand)) {
            return 0;
        }
        if (ROTATE_90_DEGREES.equals(actionCommand)) {
            return 90;
        }
        if (ROTATE_180_DEGREES.equals(actionCommand)) {
            return 180;
        }
        if (ROTATE_270_DEGREES.equals(actionCommand)) {
            return 270;
        }
        throw new IllegalArgumentException();
    }

    private JMenu createRotationMenu() {
        JMenu menu = new JMenu();
        menu.setText("Rotation");
        this.rotate0Item = new JRadioButtonMenuItem();
        this.rotate90Item = new JRadioButtonMenuItem();
        this.rotate180Item = new JRadioButtonMenuItem();
        this.rotate270Item = new JRadioButtonMenuItem();
        this.rotate0Item.setSelected(true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rotate0Item);
        bg.add(this.rotate90Item);
        bg.add(this.rotate180Item);
        bg.add(this.rotate270Item);
        this.rotate0Item.setText(ROTATE_0_DEGREES);
        this.rotate90Item.setText(ROTATE_90_DEGREES);
        this.rotate180Item.setText(ROTATE_180_DEGREES);
        this.rotate270Item.setText(ROTATE_270_DEGREES);
        menu.add(this.rotate0Item);
        menu.add(this.rotate90Item);
        menu.add(this.rotate180Item);
        menu.add(this.rotate270Item);
        return menu;
    }
}

