/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.core.impl;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Objects;
import org.apache.felix.cm.json.Configurations;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.felix.utils.collections.DictionaryAsMap;
import org.apache.karaf.util.config.ConfigurationPID;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConfigInstaller
implements ArtifactInstaller,
ConfigurationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonConfigInstaller.class);
    private final ConfigurationAdmin configurationAdmin;

    public JsonConfigInstaller(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public boolean canHandle(File artifact) {
        return artifact.getName().endsWith(".json");
    }

    public void install(File artifact) throws Exception {
        this.setConfig(artifact);
    }

    public void update(File artifact) throws Exception {
        this.setConfig(artifact);
    }

    public void uninstall(File artifact) throws Exception {
        this.deleteConfig(artifact);
    }

    private void setConfig(File artifact) throws Exception {
        String filename = artifact.getName();
        ConfigurationPID configurationPID = ConfigurationPID.parseFilename(filename);
        Configuration configuration = this.getConfiguration(this.toConfigKey(artifact), configurationPID);
        Dictionary props = configuration.getProperties();
        Hashtable old = props != null ? new Hashtable(new DictionaryAsMap(props)) : null;
        Hashtable properties = Configurations.buildReader().build((Reader)new FileReader(artifact)).readConfiguration();
        if (old != null) {
            old.remove("felix.fileinstall.filename");
            old.remove("service.pid");
            old.remove("service.factoryPid");
        }
        boolean updated = false;
        if (old == null || old.size() != properties.size()) {
            updated = true;
        } else {
            for (String key : old.keySet()) {
                Object oldValue = old.get(key);
                Object propertiesValue = properties.get(key);
                if (oldValue instanceof Object[] && propertiesValue instanceof Object[]) {
                    updated = !Arrays.deepEquals((Object[])oldValue, (Object[])propertiesValue);
                } else {
                    boolean bl = updated = !oldValue.equals(propertiesValue);
                }
                if (!updated) continue;
                break;
            }
        }
        if (updated) {
            properties.put("felix.fileinstall.filename", this.toConfigKey(artifact));
            if (old == null) {
                LOGGER.info("Creating configuration from {}", (Object)artifact.getName());
            } else {
                LOGGER.info("Updating configuration from {}", (Object)artifact.getName());
            }
            configuration.update((Dictionary)properties);
        }
    }

    void deleteConfig(File artifact) throws Exception {
        Configuration config = this.findExistingConfiguration(this.toConfigKey(artifact));
        if (Objects.nonNull(config)) {
            config.delete();
            LOGGER.info("Configuration for {} found and deleted", (Object)artifact.getName());
        } else {
            LOGGER.info("Configuration for {} not found, unable to delete", (Object)artifact.getName());
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (event.getType() == 2) {
            File file = new File(System.getProperty("karaf.etc"), event.getPid() + ".json");
            if (file.exists()) {
                file.delete();
            }
        } else if (event.getType() == 1) {
            try {
                Configuration configuration = this.configurationAdmin.getConfiguration(event.getPid(), null);
                Dictionary dictionary = configuration.getProcessedProperties(null);
                File file = null;
                if (dictionary.get("felix.fileinstall.filename") != null) {
                    file = this.getCfgFileFromProperty(configuration.getProperties().get("felix.fileinstall.filename"));
                }
                if (file != null && this.canHandle(file)) {
                    dictionary.remove("felix.fileinstall.filename");
                    dictionary.remove("service.pid");
                    dictionary.remove("service.factoryPid");
                    Configurations.buildWriter().build((Writer)new FileWriter(file)).writeConfiguration(dictionary);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Can't update json configuration file", (Throwable)e);
            }
        }
    }

    private File getCfgFileFromProperty(Object val) throws URISyntaxException, MalformedURLException {
        if (val instanceof URL) {
            return new File(((URL)val).toURI());
        }
        if (val instanceof URI) {
            return new File((URI)val);
        }
        if (val instanceof String) {
            return new File(new URL((String)val).toURI());
        }
        return null;
    }

    String toConfigKey(File f) {
        return f.getAbsoluteFile().toURI().toString();
    }

    Configuration getConfiguration(String configKey, ConfigurationPID configurationPID) throws Exception {
        Configuration cachedConfiguration;
        Configuration oldConfiguration = this.findExistingConfiguration(configKey);
        Configuration configuration = cachedConfiguration = oldConfiguration != null ? this.configurationAdmin.getConfiguration(oldConfiguration.getPid(), null) : null;
        if (cachedConfiguration != null) {
            return cachedConfiguration;
        }
        Configuration newConfiguration = configurationPID.isFactory() ? (configurationPID.isR7() ? this.configurationAdmin.getFactoryConfiguration(configurationPID.getFactoryPid(), configurationPID.getName(), "?") : this.configurationAdmin.createFactoryConfiguration(configurationPID.getFactoryPid(), "?")) : this.configurationAdmin.getConfiguration(configurationPID.getPid(), "?");
        return newConfiguration;
    }

    Configuration findExistingConfiguration(String configKey) throws Exception {
        String filter = "(felix.fileinstall.filename=" + this.escapeFilterValue(configKey) + ")";
        Configuration[] configurations = this.configurationAdmin.listConfigurations(filter);
        if (configurations != null && configurations.length > 0) {
            return configurations[0];
        }
        return null;
    }

    private String escapeFilterValue(String s) {
        return s.replaceAll("[(]", "\\\\(").replaceAll("[)]", "\\\\)").replaceAll("[=]", "\\\\=").replaceAll("[\\*]", "\\\\*");
    }
}

