/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jclouds.openstack.heat.v1.features;

import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.jclouds.Fallbacks.NullOnNotFoundOr404;
import org.jclouds.openstack.heat.v1.domain.Template;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;

/**
 * Provides access to Resource features.
 *
 */
@RequestFilters(AuthenticateRequest.class)
public interface TemplateApi {

   /**
    * Normal response codes: 200

    Error response codes: badRequest (400), unauthorized (401), notFound (404), internalServerError (500)
    */
   @Named("validation:validate_template")
   @POST
   @Consumes(MediaType.APPLICATION_JSON)
   @Produces(MediaType.APPLICATION_JSON)
   @Path("/validate")
   @Payload("%7B\"template_url\":\"{url}\"%7D")
   Template validate(@PayloadParam("url") String template_url);

   @Named("validation:get_template")
   @GET
   @Consumes(MediaType.APPLICATION_JSON)
   @Path("/stacks/{stack_name}/{stack_id}/template")
   @Fallback(NullOnNotFoundOr404.class)
   Template get(@PathParam("stack_name") String name, @PathParam("stack_id") String id);
}
