/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class PropertyChangeMulticaster
implements Serializable {
    protected transient PropertyChangeListener[] listeners = new PropertyChangeListener[0];
    protected final Object source;
    protected HashMap children;

    protected synchronized PropertyChangeMulticaster getChild(String string) {
        return this.children == null ? null : (PropertyChangeMulticaster)this.children.get(string);
    }

    public PropertyChangeMulticaster(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException();
        }
        int n = this.listeners.length;
        PropertyChangeListener[] propertyChangeListenerArray = new PropertyChangeListener[n + 1];
        if (n > 0) {
            System.arraycopy(this.listeners, 0, propertyChangeListenerArray, 0, n);
        }
        propertyChangeListenerArray[n] = propertyChangeListener;
        this.listeners = propertyChangeListenerArray;
    }

    public synchronized void addPropertyChangeListenerIfAbsent(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException();
        }
        int n = this.listeners.length;
        PropertyChangeListener[] propertyChangeListenerArray = new PropertyChangeListener[n + 1];
        for (int i = 0; i < n; ++i) {
            propertyChangeListenerArray[i] = this.listeners[i];
            if (!propertyChangeListener.equals(this.listeners[i])) continue;
            return;
        }
        propertyChangeListenerArray[n] = propertyChangeListener;
        this.listeners = propertyChangeListenerArray;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        int n = this.listeners.length - 1;
        if (n < 0 || propertyChangeListener == null) {
            return;
        }
        PropertyChangeListener[] propertyChangeListenerArray = new PropertyChangeListener[n];
        for (int i = 0; i < n; ++i) {
            if (propertyChangeListener.equals(this.listeners[i])) {
                for (int j = i + 1; j <= n; ++j) {
                    propertyChangeListenerArray[j - 1] = this.listeners[j];
                }
                this.listeners = propertyChangeListenerArray;
                return;
            }
            propertyChangeListenerArray[i] = this.listeners[i];
        }
        if (propertyChangeListener.equals(this.listeners[n])) {
            this.listeners = propertyChangeListenerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException();
        }
        PropertyChangeMulticaster propertyChangeMulticaster = null;
        PropertyChangeMulticaster propertyChangeMulticaster2 = this;
        synchronized (propertyChangeMulticaster2) {
            if (this.children == null) {
                this.children = new HashMap();
            } else {
                propertyChangeMulticaster = (PropertyChangeMulticaster)this.children.get(string);
            }
            if (propertyChangeMulticaster == null) {
                propertyChangeMulticaster = new PropertyChangeMulticaster(this.source);
                this.children.put(string, propertyChangeMulticaster);
            }
        }
        propertyChangeMulticaster.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListenerIfAbsent(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException();
        }
        PropertyChangeMulticaster propertyChangeMulticaster = null;
        PropertyChangeMulticaster propertyChangeMulticaster2 = this;
        synchronized (propertyChangeMulticaster2) {
            if (this.children == null) {
                this.children = new HashMap();
            } else {
                propertyChangeMulticaster = (PropertyChangeMulticaster)this.children.get(string);
            }
            if (propertyChangeMulticaster == null) {
                propertyChangeMulticaster = new PropertyChangeMulticaster(this.source);
                this.children.put(string, propertyChangeMulticaster);
            }
        }
        propertyChangeMulticaster.addPropertyChangeListenerIfAbsent(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        PropertyChangeMulticaster propertyChangeMulticaster = this.getChild(string);
        if (propertyChangeMulticaster != null) {
            propertyChangeMulticaster.removePropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void multicast(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener[] propertyChangeListenerArray;
        PropertyChangeMulticaster propertyChangeMulticaster = null;
        PropertyChangeMulticaster propertyChangeMulticaster2 = this;
        synchronized (propertyChangeMulticaster2) {
            propertyChangeListenerArray = this.listeners;
            if (this.children != null && propertyChangeEvent.getPropertyName() != null) {
                propertyChangeMulticaster = (PropertyChangeMulticaster)this.children.get(propertyChangeEvent.getPropertyName());
            }
        }
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            propertyChangeListenerArray[i].propertyChange(propertyChangeEvent);
        }
        if (propertyChangeMulticaster != null) {
            propertyChangeMulticaster.multicast(propertyChangeEvent);
        }
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        if (object == null || object2 == null || !object.equals(object2)) {
            this.multicast(new PropertyChangeEvent(this.source, string, object, object2));
        }
    }

    public void firePropertyChange(String string, int n, int n2) {
        if (n != n2) {
            this.multicast(new PropertyChangeEvent(this.source, string, new Integer(n), new Integer(n2)));
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            this.multicast(new PropertyChangeEvent(this.source, string, new Boolean(bl), new Boolean(bl2)));
        }
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        if (object == null || object2 == null || !object.equals(object2)) {
            this.multicast(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners(String string) {
        PropertyChangeMulticaster propertyChangeMulticaster;
        PropertyChangeMulticaster propertyChangeMulticaster2 = this;
        synchronized (propertyChangeMulticaster2) {
            if (this.listeners.length > 0) {
                return true;
            }
            if (string == null || this.children == null) {
                return false;
            }
            propertyChangeMulticaster = (PropertyChangeMulticaster)this.children.get(string);
            if (propertyChangeMulticaster == null) {
                return false;
            }
        }
        return propertyChangeMulticaster.hasListeners(null);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i = 0; i < this.listeners.length; ++i) {
            PropertyChangeListener propertyChangeListener = this.listeners[i];
            if (!(this.listeners[i] instanceof Serializable)) continue;
            objectOutputStream.writeObject(this.listeners[i]);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        this.listeners = new PropertyChangeListener[0];
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            this.addPropertyChangeListener((PropertyChangeListener)object);
        }
    }
}

