/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.validator;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.ConfigurationUtil;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.containerkit.profile.ComponentProfile;
import org.apache.avalon.phoenix.framework.info.SchemaDescriptor;
import org.apache.avalon.phoenix.interfaces.ConfigurationValidator;
import org.apache.avalon.phoenix.tools.configuration.ConfigurationBuilder;
import org.realityforge.configkit.ConfigValidator;
import org.realityforge.configkit.ConfigValidatorFactory;
import org.realityforge.configkit.ValidationResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DefaultConfigurationValidator
extends AbstractLogEnabled
implements ConfigurationValidator,
Configurable {
    private final Map m_uriMap = new HashMap();

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] children = configuration.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Configuration child = children[i];
            String key = child.getAttribute("name");
            String uri = child.getAttribute("uri");
            this.m_uriMap.put(key, uri);
        }
    }

    public boolean isValid(ComponentProfile component, ClassLoader classLoader) throws ConfigurationException {
        String type;
        SchemaDescriptor schema = component.getInfo().getConfigurationSchema();
        if (null == schema) {
            return true;
        }
        if (this.getLogger().isDebugEnabled()) {
            String message = "Validating component " + component.getMetaData().getName() + " of type " + component.getInfo().getDescriptor().getImplementationKey() + " with schema " + schema.getLocation() + " of type " + schema.getType();
            this.getLogger().debug(message);
        }
        if (!(type = this.getType(schema)).equals(schema.getType())) {
            String message = "Schema type specified as " + schema.getType() + " was translated to URI " + type + " for component named " + component.getMetaData().getName() + " of type " + component.getInfo().getDescriptor().getImplementationKey() + ". It is recomended that the components Info specify the " + "URI rather than the type for compatability reasons.";
            System.err.println(message);
            this.getLogger().warn(message);
        }
        InputSource inputSource = this.getSchemaInputSource(component, classLoader);
        try {
            ConfigValidator validator = ConfigValidatorFactory.create((String)type, (InputSource)inputSource);
            Configuration configuration = component.getMetaData().getConfiguration();
            DefaultConfiguration newConfiguration = new DefaultConfiguration("root", configuration.getLocation());
            newConfiguration.addAll(configuration);
            Element element = ConfigurationUtil.toElement((Configuration)newConfiguration);
            ValidationResult result = validator.validate((Node)element);
            ConfigurationBuilder.processValidationResults((ValidationResult)result, (Logger)this.getLogger());
            return true;
        }
        catch (Exception e) {
            String msg = component.getMetaData().getName() + " failed validation due to: " + e.getMessage();
            this.getLogger().warn(msg, (Throwable)e);
            return false;
        }
    }

    private String getType(SchemaDescriptor schema) {
        String type = schema.getType();
        String uri = (String)this.m_uriMap.get(type);
        if (null != uri) {
            return uri;
        }
        return type;
    }

    private InputSource getSchemaInputSource(ComponentProfile component, ClassLoader classLoader) throws ConfigurationException {
        SchemaDescriptor schema = component.getInfo().getConfigurationSchema();
        String resource = this.calcSchemaResource(component);
        InputStream inputStream = classLoader.getResourceAsStream(resource);
        if (null == inputStream) {
            String message = "Unable to find Schema for component " + component.getMetaData().getName() + " of type " + component.getInfo().getDescriptor().getImplementationKey() + " at location " + resource;
            throw new ConfigurationException(message);
        }
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(schema.getLocation());
        return inputSource;
    }

    private String calcSchemaResource(ComponentProfile component) {
        String classname;
        SchemaDescriptor schema = component.getInfo().getConfigurationSchema();
        String location = schema.getLocation();
        if (location.startsWith("/")) {
            return location;
        }
        String resource = classname = component.getInfo().getDescriptor().getImplementationKey();
        int index = classname.lastIndexOf(46);
        resource = classname;
        if (-1 != index) {
            resource = classname.substring(0, index + 1);
        }
        resource = resource.replace('.', '/');
        resource = resource + location;
        return resource;
    }
}

