/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.classloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.avalon.phoenix.components.classloader.SimpleLoaderResolver;
import org.apache.avalon.phoenix.components.extensions.pkgmgr.PackageManager;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

class DefaultLoaderResolver
extends SimpleLoaderResolver {
    public DefaultLoaderResolver(File baseDirectory, PackageManager manager) {
        super(baseDirectory, manager);
    }

    public URL[] resolveFileSet(String baseDirectory, String[] includes, String[] excludes) throws Exception {
        File base = this.getFileFor(".");
        return this.resolveFileSet(base, baseDirectory, includes, excludes);
    }

    protected final URL[] resolveFileSet(File base, String baseDirectory, String[] includes, String[] excludes) {
        String newBaseDirectory = DefaultLoaderResolver.normalize(baseDirectory);
        File newBase = new File(base, newBaseDirectory);
        ArrayList urls = new ArrayList();
        if (newBase.exists() && newBase.isDirectory()) {
            PathMatcher matcher = new PathMatcher(includes, excludes);
            this.scanDir(newBase, matcher, "", urls);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private void scanDir(File dir, PathMatcher matcher, String path, ArrayList urls) {
        File[] files = dir.listFiles();
        if (null == files) {
            String message = "Bad dir specified: " + dir;
            throw new IllegalArgumentException(message);
        }
        String prefix = "";
        if (0 != path.length()) {
            prefix = path + "/";
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String newPath = prefix + file.getName();
            if (file.isDirectory()) {
                this.scanDir(file, matcher, newPath, urls);
                continue;
            }
            if (!matcher.match(newPath)) continue;
            try {
                urls.add(file.toURL());
                continue;
            }
            catch (MalformedURLException mue) {
                String message = "Error converting " + file + " to url. Reason: " + mue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    private String[] prefixPatterns(String prefix, String[] patterns) {
        if (0 == prefix.length()) {
            return patterns;
        }
        String[] newPatterns = new String[patterns.length];
        for (int i = 0; i < newPatterns.length; ++i) {
            newPatterns[i] = prefix + "/" + patterns[i];
        }
        return newPatterns;
    }

    private static final String normalize(String path) {
        char firstChar;
        if (".".equals(path) || "./".equals(path)) {
            return "";
        }
        if (path.length() < 2) {
            return path;
        }
        StringBuffer buff = new StringBuffer(path);
        int length = path.length();
        String prefix = null;
        if (length > 2 && buff.charAt(1) == ':') {
            prefix = path.substring(0, 2);
            buff.delete(0, 2);
            path = path.substring(2);
            length -= 2;
        }
        boolean startsWithSlash = length > 0 && (buff.charAt(0) == '/' || buff.charAt(0) == '\\');
        boolean expStart = true;
        int ptCount = 0;
        int lastSlash = length + 1;
        int upLevel = 0;
        block13: for (int i = length - 1; i >= 0; --i) {
            switch (path.charAt(i)) {
                case '\\': {
                    buff.setCharAt(i, '/');
                }
                case '/': {
                    if (lastSlash == i + 1) {
                        buff.deleteCharAt(i);
                    }
                    switch (ptCount) {
                        case 1: {
                            buff.delete(i, lastSlash);
                            break;
                        }
                        case 2: {
                            ++upLevel;
                            break;
                        }
                        default: {
                            if (upLevel <= 0 || lastSlash == i + 1) break;
                            buff.delete(i, lastSlash + 3);
                            --upLevel;
                        }
                    }
                    ptCount = 0;
                    expStart = true;
                    lastSlash = i;
                    continue block13;
                }
                case '.': {
                    if (!expStart) continue block13;
                    ++ptCount;
                    continue block13;
                }
                default: {
                    ptCount = 0;
                    expStart = false;
                }
            }
        }
        switch (ptCount) {
            case 1: {
                buff.delete(0, lastSlash);
                break;
            }
            case 2: {
                break;
            }
            default: {
                if (upLevel > 0) {
                    if (startsWithSlash) {
                        return null;
                    }
                    upLevel = 1;
                }
                while (upLevel > 0) {
                    buff.delete(0, lastSlash + 3);
                    --upLevel;
                }
                break block9;
            }
        }
        length = buff.length();
        boolean isLengthNull = length == 0;
        char c = firstChar = isLengthNull ? (char)'\u0000' : buff.charAt(0);
        if (!startsWithSlash && !isLengthNull && firstChar == '/') {
            buff.deleteCharAt(0);
        } else if (startsWithSlash && (isLengthNull || !isLengthNull && firstChar != '/')) {
            buff.insert(0, '/');
        }
        if (prefix != null) {
            buff.insert(0, prefix);
        }
        return buff.toString();
    }

    public final class PathMatcher {
        private final Pattern[] m_includes;
        private final Pattern[] m_excludes;
        private final Perl5Matcher m_matcher = new Perl5Matcher();

        public PathMatcher(String[] includes, String[] excludes) {
            if (null == includes) {
                throw new NullPointerException("includes");
            }
            if (null == excludes) {
                throw new NullPointerException("excludes");
            }
            this.m_includes = this.toPatterns(includes);
            this.m_excludes = this.toPatterns(excludes);
        }

        public boolean match(String vPath) {
            if (this.isExcluded(vPath)) {
                return false;
            }
            return this.isIncluded(vPath);
        }

        private boolean isExcluded(String vPath) {
            return this.testMatch(this.m_excludes, vPath);
        }

        private boolean isIncluded(String vPath) {
            return this.testMatch(this.m_includes, vPath);
        }

        private boolean testMatch(Pattern[] patterns, String vPath) {
            for (int i = 0; i < patterns.length; ++i) {
                if (!this.m_matcher.matches(vPath, patterns[i])) continue;
                return true;
            }
            return false;
        }

        private Pattern[] toPatterns(String[] strs) {
            Perl5Compiler compiler = new Perl5Compiler();
            Pattern[] patterns = new Pattern[strs.length];
            for (int i = 0; i < patterns.length; ++i) {
                String perlPatternStr = this.toPerlPatternStr(strs[i]);
                try {
                    patterns[i] = compiler.compile(perlPatternStr);
                    continue;
                }
                catch (MalformedPatternException mpe) {
                    throw new IllegalArgumentException(mpe.toString());
                }
            }
            return patterns;
        }

        private String toPerlPatternStr(String str) {
            StringBuffer sb = new StringBuffer();
            int size = str.length();
            for (int i = 0; i < size; ++i) {
                char ch = str.charAt(i);
                if ('.' == ch || '/' == ch || '\\' == ch) {
                    sb.append('\\');
                    sb.append(ch);
                    continue;
                }
                if ('*' == ch) {
                    if (i + 2 < size && '*' == str.charAt(i + 1) && '/' == str.charAt(i + 2)) {
                        sb.append("([^/]*/)*");
                        i += 2;
                        continue;
                    }
                    sb.append("[^/]*");
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
    }
}

