/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.tools.metagenerate;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.phoenix.tools.metagenerate.NamedXmlSnippet;

public class MxinfoHelper {
    private static final String[] HEADER = new String[]{"<?xml version=\"1.0\"?>", "<!DOCTYPE mxinfo PUBLIC \"-//PHOENIX/Mx Info DTD Version 1.0//EN\"", "                  \"http://jakarta.apache.org/avalon/dtds/phoenix/mxinfo_1_0.dtd\">", "", "<mxinfo>", ""};
    private static final String[] TOPIC = new String[]{"    <topic name=\"@TOPIC@\" >"};
    private static final String[] ATTR_HEADER = new String[]{"", "      <!-- attributes -->"};
    private static final String[] ATTRIBUTE = new String[]{"      <attribute", "        name=\"@NAME@\"", "        description=\"@DESCRIPTION@\"", "        type=\"@RETURN@\"", "      />"};
    private static final String[] OPERATIONS_HEADER = new String[]{"", "      <!-- operations -->", ""};
    private static final String[] OPERATION_HEADER = new String[]{"      <operation", "        name=\"@NAME@\"", "        description=\"@DESCRIPTION@\"", "        type=\"@RETURN@\">"};
    private static final String[] PARAMETER = new String[]{"        <param", "           name=\"@NAME@\"", "           description=\"@DESCRIPTION@\"", "           type=\"@TYPE@\"", "        />"};
    private static final String[] OPERATION_FOOTER = new String[]{"      </operation>"};
    private static final String[] FOOTER = new String[]{"", "    </topic>", "", "</mxinfo>"};
    private final FileWriter m_output;

    public MxinfoHelper(File file) throws IOException {
        this.m_output = new FileWriter(file);
    }

    public void writeHeader(String topic) throws IOException {
        int i;
        for (i = 0; i < HEADER.length; ++i) {
            this.m_output.write(HEADER[i] + "\n");
        }
        for (i = 0; i < TOPIC.length; ++i) {
            String line = TOPIC[i];
            line = this.replaceString(line, "\"@TOPIC@\"", topic);
            this.m_output.write(line + "\n");
        }
        for (i = 0; i < ATTR_HEADER.length; ++i) {
            this.m_output.write(ATTR_HEADER[i] + "\n");
        }
    }

    public NamedXmlSnippet makeAttrLines(String attrName, String description, String type) {
        String xml = "";
        for (int i = 0; i < ATTRIBUTE.length; ++i) {
            String line = ATTRIBUTE[i];
            line = this.replaceString(line, "@NAME@", attrName);
            line = this.replaceString(line, "\"@DESCRIPTION@\"", description);
            line = this.replaceString(line, "@RETURN@", type);
            xml = xml + line + "\n";
        }
        return new NamedXmlSnippet(attrName, xml);
    }

    public void writeAttributes(List attributes) throws IOException {
        Collections.sort(attributes);
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            NamedXmlSnippet attribute = (NamedXmlSnippet)iterator.next();
            this.m_output.write(attribute.getXml());
        }
    }

    public void writeOperationsHeader() throws IOException {
        for (int i = 0; i < OPERATIONS_HEADER.length; ++i) {
            this.m_output.write(OPERATIONS_HEADER[i] + "\n");
        }
    }

    public String makeOperationHeader(String operName, String description, String type) throws IOException {
        String xml = "";
        for (int i = 0; i < OPERATION_HEADER.length; ++i) {
            String line = OPERATION_HEADER[i];
            line = this.replaceString(line, "@NAME@", operName);
            line = this.replaceString(line, "@DESCRIPTION@", description);
            line = this.replaceString(line, "@RETURN@", type);
            xml = xml + line + "\n";
        }
        return xml;
    }

    public String makeOperationFooter() throws IOException {
        String xml = "";
        for (int i = 0; i < OPERATION_FOOTER.length; ++i) {
            xml = xml + OPERATION_FOOTER[i] + "\n";
        }
        return xml;
    }

    public String makeOperationParameter(String paramName, String description, String type) throws IOException {
        String xml = "";
        for (int i = 0; i < PARAMETER.length; ++i) {
            String line = PARAMETER[i];
            line = this.replaceString(line, "@NAME@", paramName);
            line = this.replaceString(line, "@DESCRIPTION@", description);
            line = this.replaceString(line, "@TYPE@", type);
            xml = xml + line + "\n";
        }
        return xml;
    }

    public void writeOperations(List operations) throws IOException {
        Collections.sort(operations);
        Iterator iterator = operations.iterator();
        while (iterator.hasNext()) {
            NamedXmlSnippet operation = (NamedXmlSnippet)iterator.next();
            this.m_output.write(operation.getXml());
        }
    }

    public void writeFooter() throws IOException {
        for (int i = 0; i < FOOTER.length; ++i) {
            this.m_output.write(FOOTER[i] + "\n");
        }
    }

    public void close() throws IOException {
        this.m_output.close();
    }

    protected String replaceString(String source, String term, String replacement) {
        String retval = source;
        int ix = retval.indexOf(term);
        if (ix != -1) {
            retval = retval.substring(0, ix) + replacement + retval.substring(ix + term.length(), retval.length());
        }
        return retval;
    }
}

