/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.tools.configuration;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.logger.Logger;
import org.realityforge.configkit.ConfigValidator;
import org.realityforge.configkit.ConfigValidatorFactory;
import org.realityforge.configkit.ResolverFactory;
import org.realityforge.configkit.ValidateException;
import org.realityforge.configkit.ValidationIssue;
import org.realityforge.configkit.ValidationResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class ConfigurationBuilder {
    public static final String COMPONENTINFO_SCHEMA = "-//AVALON/Component Info DTD Version 1.0//EN";
    public static final String BLOCKINFO_SCHEMA = "-//PHOENIX/Block Info DTD Version 1.0//EN";
    public static final String MXINFO_SCHEMA = "-//PHOENIX/Mx Info DTD Version 1.0//EN";
    public static final String ASSEMBLY_SCHEMA = "-//PHOENIX/Assembly DTD Version 1.0//EN";
    private static EntityResolver c_resolver;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$tools$configuration$ConfigurationBuilder;

    public static Configuration build(InputSource input, String publicId, Logger logger) throws Exception {
        ConfigurationBuilder.setupResolver();
        SAXConfigurationHandler handler = new SAXConfigurationHandler();
        if (null == publicId) {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(false);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader reader = saxParser.getXMLReader();
            reader.setEntityResolver(c_resolver);
            reader.setContentHandler((ContentHandler)handler);
            reader.setErrorHandler((ErrorHandler)handler);
            reader.parse(input);
        } else {
            InputSource inputSource = c_resolver.resolveEntity(publicId, null);
            if (null == inputSource) {
                String message = "Unable to locate schema with publicID=" + publicId;
                throw new IllegalStateException(message);
            }
            ConfigValidator validator = ConfigValidatorFactory.create((InputSource)inputSource, (EntityResolver)c_resolver);
            ValidationResult result = validator.validate(input, (ContentHandler)handler);
            ConfigurationBuilder.processValidationResults(result, logger);
        }
        return handler.getConfiguration();
    }

    public static void processValidationResults(ValidationResult result, Logger logger) throws Exception {
        if (!result.isValid()) {
            ValidationIssue[] issues = result.getIssues();
            for (int i = 0; i < issues.length; ++i) {
                ValidationIssue issue = issues[i];
                SAXParseException exception = issue.getException();
                String message = exception.getMessage() + " at " + exception.getLineNumber();
                if (issue.isWarning()) {
                    logger.info(message);
                    continue;
                }
                if (issue.isError()) {
                    logger.warn(message);
                    continue;
                }
                if (!issue.isFatalError()) continue;
                logger.error(message);
            }
            ValidateException exception = result.getException();
            throw new CascadingException(exception.getMessage(), (Throwable)exception);
        }
    }

    private static void setupResolver() throws ParserConfigurationException, SAXException, IOException {
        if (null == c_resolver) {
            c_resolver = ResolverFactory.createResolver((ClassLoader)(class$org$apache$avalon$phoenix$tools$configuration$ConfigurationBuilder == null ? (class$org$apache$avalon$phoenix$tools$configuration$ConfigurationBuilder = ConfigurationBuilder.class$("org.apache.avalon.phoenix.tools.configuration.ConfigurationBuilder")) : class$org$apache$avalon$phoenix$tools$configuration$ConfigurationBuilder).getClassLoader());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

