/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.loggerstore;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.realityforge.loggerstore.LoggerStore;
import org.realityforge.loggerstore.LoggerStoreFactory;

public class InitialLoggerStoreFactory
implements LoggerStoreFactory {
    public static final String INITIAL_FACTORY = "org.realityforge.loggerstore.factory";
    public static final String DEFAULT_PROPERTIES = "META-INF/spice/loggerstore.properties";
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$realityforge$loggerstore$Configurator;

    public LoggerStore createLoggerStore(Map config) throws Exception {
        ClassLoader classLoader = this.getClassLoader(config);
        String type = (String)config.get(INITIAL_FACTORY);
        Map data = config;
        if (null == type) {
            data = this.loadDefaultConfig(data, classLoader);
            type = (String)data.get(INITIAL_FACTORY);
        }
        LoggerStoreFactory factory = this.createLoggerStoreFactory(type, classLoader);
        return factory.createLoggerStore(data);
    }

    private ClassLoader getClassLoader(Map data) {
        ClassLoader loader = (ClassLoader)data.get((class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = InitialLoggerStoreFactory.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getName());
        if (null == loader && null == (loader = Thread.currentThread().getContextClassLoader())) {
            loader = (class$org$realityforge$loggerstore$Configurator == null ? (class$org$realityforge$loggerstore$Configurator = InitialLoggerStoreFactory.class$("org.realityforge.loggerstore.Configurator")) : class$org$realityforge$loggerstore$Configurator).getClassLoader();
        }
        return loader;
    }

    private Map loadDefaultConfig(Map initial, ClassLoader classLoader) throws Exception {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Enumeration<URL> resources = classLoader.getResources(DEFAULT_PROPERTIES);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            InputStream stream = url.openStream();
            Properties properties = new Properties();
            properties.load(stream);
            map.putAll(properties);
        }
        map.putAll(initial);
        return map;
    }

    private LoggerStoreFactory createLoggerStoreFactory(String type, ClassLoader classLoader) {
        if (null == type) {
            String message = "No LoggerStoreFactory type specified.";
            throw new IllegalStateException("No LoggerStoreFactory type specified.");
        }
        try {
            Class<?> clazz = classLoader.loadClass(type);
            return (LoggerStoreFactory)clazz.newInstance();
        }
        catch (Exception e) {
            String message = "Failed to created LoggerStoreFactory " + type;
            throw new IllegalArgumentException(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        INITIAL_FACTORY = INITIAL_FACTORY;
        DEFAULT_PROPERTIES = DEFAULT_PROPERTIES;
    }
}

