/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.loggerstore;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.realityforge.loggerstore.LoggerStore;

public abstract class AbstractLoggerStore
implements LoggerStore,
LogEnabled {
    private final Map m_loggers = new HashMap();
    private Logger m_logger;
    private Logger m_rootLogger;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public Logger getLogger() throws Exception {
        Logger logger;
        if (this.m_logger != null && this.m_logger.isDebugEnabled()) {
            String message = "Root Logger returned";
            this.m_logger.debug("Root Logger returned");
        }
        if ((logger = this.getRootLogger()) == null) {
            String message = "Root Logger is not defined";
            throw new Exception("Root Logger is not defined");
        }
        return logger;
    }

    public Logger getLogger(String name) throws Exception {
        if (null == name) {
            throw new NullPointerException("name");
        }
        Logger logger = this.retrieveLogger(name);
        if (logger == null) {
            if (this.m_logger != null && this.m_logger.isDebugEnabled()) {
                String message = "Logger named '" + name + "' not defined in configuration. New Logger " + "created and returned.";
                this.m_logger.debug(message);
            }
            Logger logger1 = logger = this.createLogger(name);
            this.m_loggers.put(name, logger1);
        }
        return logger;
    }

    protected abstract Logger createLogger(String var1);

    protected final void setRootLogger(Logger rootLogger) {
        this.m_rootLogger = rootLogger;
    }

    protected final Logger getRootLogger() {
        return this.m_rootLogger;
    }

    private Logger retrieveLogger(String name) {
        Logger logger = (Logger)this.m_loggers.get(name);
        if (null != logger && null != this.m_logger && this.m_logger.isDebugEnabled()) {
            String message = "Retrieved Logger named: " + name;
            this.m_logger.debug(message);
        }
        return logger;
    }
}

