/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.JavaSource;
import java.io.Serializable;

public class Type
implements Comparable,
Serializable {
    private String name;
    private JavaSource parentSource;
    private String fullName;
    private int dimensions;

    public Type(String name, int dimensions, JavaSource parentSource) {
        this.name = name;
        this.dimensions = dimensions;
        this.parentSource = parentSource;
    }

    public Type(String fullName, int dimensions) {
        this.fullName = fullName;
        this.dimensions = dimensions;
    }

    public Type(String fullName) {
        this(fullName, 0);
    }

    public JavaSource getParentSource() {
        return this.parentSource;
    }

    public void setParentSource(JavaSource javaSource) {
        this.parentSource = javaSource;
    }

    public String getValue() {
        return this.isResolved() ? this.fullName : this.name;
    }

    public boolean isResolved() {
        if (this.fullName == null && this.parentSource != null) {
            this.fullName = this.parentSource.resolveType(this.name);
        }
        return this.fullName != null;
    }

    public int compareTo(Object o) {
        if (!(o instanceof Type)) {
            return 0;
        }
        return this.getValue().compareTo(((Type)o).getValue());
    }

    public boolean isArray() {
        return this.dimensions > 0;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public boolean equals(Object obj) {
        Type t = (Type)obj;
        return t.getValue().equals(this.getValue()) && t.getDimensions() == this.getDimensions();
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }
}

