/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.IndentBuffer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractJavaEntity
implements Serializable {
    protected String name;
    protected List modifiers = new ArrayList();
    private String comment;
    private DocletTag[] tags = new DocletTag[0];

    public String getName() {
        return this.name;
    }

    public String[] getModifiers() {
        return this.modifiers.toArray(new String[this.modifiers.size()]);
    }

    public String getComment() {
        return this.comment;
    }

    public DocletTag[] getTags() {
        return this.tags;
    }

    public DocletTag[] getTagsByName(String name) {
        ArrayList<DocletTag> specifiedTags = new ArrayList<DocletTag>();
        int i = 0;
        while (i < this.tags.length) {
            DocletTag docletTag = this.tags[i];
            if (docletTag.getName().equals(name)) {
                specifiedTags.add(docletTag);
            }
            ++i;
        }
        return specifiedTags.toArray(new DocletTag[specifiedTags.size()]);
    }

    public DocletTag getTagByName(String name) {
        int i = 0;
        while (i < this.tags.length) {
            DocletTag docletTag = this.tags[i];
            if (docletTag.getName().equals(name)) {
                return docletTag;
            }
            ++i;
        }
        return null;
    }

    void commentHeader(IndentBuffer buffer) {
        if (this.comment == null && (this.tags == null || this.tags.length == 0)) {
            return;
        }
        buffer.write("/**");
        buffer.newline();
        if (this.comment != null && this.comment.length() > 0) {
            buffer.write(" * ");
            buffer.write(this.comment);
            buffer.newline();
        }
        if (this.tags != null && this.tags.length > 0) {
            if (this.comment != null && this.comment.length() > 0) {
                buffer.write(" *");
                buffer.newline();
            }
            int i = 0;
            while (i < this.tags.length) {
                DocletTag docletTag = this.tags[i];
                buffer.write(" * @");
                buffer.write(docletTag.getName());
                if (docletTag.getValue().length() > 0) {
                    buffer.write(' ');
                    buffer.write(docletTag.getValue());
                }
                buffer.newline();
                ++i;
            }
        }
        buffer.write(" */");
        buffer.newline();
    }

    public String toString() {
        IndentBuffer result = new IndentBuffer();
        this.write(result);
        return result.toString();
    }

    protected void write(IndentBuffer result) {
        this.commentHeader(result);
        this.writeBody(result);
    }

    protected abstract void writeBody(IndentBuffer var1);

    public void setName(String name) {
        this.name = name;
    }

    public void setModifiers(String[] modifiers) {
        this.modifiers = Arrays.asList(modifiers);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setTags(List tags) {
        this.tags = new DocletTag[tags.size()];
        tags.toArray(this.tags);
    }

    public boolean isAbstract() {
        return this.isModifierPresent("abstract");
    }

    public boolean isPublic() {
        return this.isModifierPresent("public");
    }

    public boolean isPrivate() {
        return this.isModifierPresent("private");
    }

    public boolean isProtected() {
        return this.isModifierPresent("protected");
    }

    public boolean isStatic() {
        return this.isModifierPresent("static");
    }

    public boolean isFinal() {
        return this.isModifierPresent("final");
    }

    public boolean isSynchronized() {
        return this.isModifierPresent("synchronized");
    }

    private boolean isModifierPresent(String modifier) {
        return this.modifiers.contains(modifier);
    }

    protected void writeNonAccessibilityModifiers(IndentBuffer result) {
        Iterator iter = this.modifiers.iterator();
        while (iter.hasNext()) {
            String modifier = (String)iter.next();
            if (modifier.startsWith("p")) continue;
            result.write(modifier);
            result.write(' ');
        }
    }

    protected void writeAccessibilityModifier(IndentBuffer result) {
        Iterator iter = this.modifiers.iterator();
        while (iter.hasNext()) {
            String modifier = (String)iter.next();
            if (!modifier.startsWith("p")) continue;
            result.write(modifier);
            result.write(' ');
        }
    }

    protected void writeAllModifiers(IndentBuffer result) {
        Iterator iter = this.modifiers.iterator();
        while (iter.hasNext()) {
            String modifier = (String)iter.next();
            result.write(modifier);
            result.write(' ');
        }
    }
}

