/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.thread.impl;

import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.SoftResourceLimitingPool;
import org.apache.avalon.excalibur.thread.impl.BasicThreadPool;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.thread.Executable;
import org.apache.excalibur.thread.ThreadControl;
import org.apache.excalibur.thread.ThreadPool;

public class DefaultThreadPool
extends ThreadGroup
implements ObjectFactory,
LogEnabled,
Disposable,
ThreadPool {
    private final BasicThreadPool m_pool;
    private SoftResourceLimitingPool m_underlyingPool;

    public DefaultThreadPool(int capacity) throws Exception {
        this("Worker Pool", capacity);
    }

    public DefaultThreadPool(String name, int capacity) throws Exception {
        super(name);
        this.m_underlyingPool = new SoftResourceLimitingPool((ObjectFactory)this, capacity);
        this.m_pool = new BasicThreadPool(this, name, (Pool)this.m_underlyingPool);
    }

    public DefaultThreadPool(String name, int min, int max) throws Exception {
        super(name);
        this.m_underlyingPool = new SoftResourceLimitingPool((ObjectFactory)this, min, max);
        this.m_pool = new BasicThreadPool(this, name, (Pool)this.m_underlyingPool);
    }

    public void enableLogging(Logger logger) {
        ContainerUtil.enableLogging((Object)this.m_pool, (Logger)logger);
    }

    public void dispose() {
        this.m_pool.dispose();
        this.destroy();
    }

    public Object newInstance() {
        return this.m_pool.newInstance();
    }

    public void decommission(Object object) {
        this.m_pool.decommission(object);
    }

    public Class getCreatedClass() {
        return this.m_pool.getCreatedClass();
    }

    public ThreadControl execute(org.apache.avalon.framework.activity.Executable work) {
        return this.m_pool.execute(work);
    }

    public ThreadControl execute(Runnable work) {
        return this.m_pool.execute(work);
    }

    public ThreadControl execute(Executable work) {
        return this.m_pool.execute(work);
    }
}

