/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.thread.impl;

import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.thread.impl.ExecutableExecuteable;
import org.apache.avalon.excalibur.thread.impl.SimpleWorkerThread;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Executable;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.thread.ThreadControl;
import org.apache.excalibur.thread.ThreadPool;
import org.apache.excalibur.thread.impl.AbstractThreadPool;
import org.apache.excalibur.thread.impl.WorkerThread;

class BasicThreadPool
extends AbstractThreadPool
implements ObjectFactory,
LogEnabled,
Disposable,
ThreadPool {
    private Pool m_pool;
    private Logger m_logger;
    static /* synthetic */ Class class$org$apache$avalon$excalibur$thread$impl$SimpleWorkerThread;

    public BasicThreadPool(ThreadGroup threadGroup, String name, Pool pool) throws Exception {
        super(name, threadGroup);
        if (null == pool) {
            throw new NullPointerException("pool");
        }
        this.m_pool = pool;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
        ContainerUtil.enableLogging((Object)this.m_pool, (Logger)logger);
    }

    public void dispose() {
        ContainerUtil.dispose((Object)this.m_pool);
        this.m_pool = null;
    }

    public Object newInstance() {
        return this.createWorker();
    }

    protected WorkerThread newWorkerThread(String name) {
        SimpleWorkerThread thread = new SimpleWorkerThread(this, this.getThreadGroup(), name);
        ContainerUtil.enableLogging((Object)thread, (Logger)this.m_logger.getChildLogger("worker"));
        return thread;
    }

    public void decommission(Object object) {
        if (object instanceof WorkerThread) {
            this.destroyWorker((WorkerThread)object);
        }
    }

    public Class getCreatedClass() {
        return class$org$apache$avalon$excalibur$thread$impl$SimpleWorkerThread == null ? (class$org$apache$avalon$excalibur$thread$impl$SimpleWorkerThread = BasicThreadPool.class$("org.apache.avalon.excalibur.thread.impl.SimpleWorkerThread")) : class$org$apache$avalon$excalibur$thread$impl$SimpleWorkerThread;
    }

    public ThreadControl execute(Executable work) {
        return this.execute(new ExecutableExecuteable(work));
    }

    protected WorkerThread getWorker() {
        try {
            return (WorkerThread)this.m_pool.get();
        }
        catch (Exception e) {
            String message = "Unable to access thread pool due to " + e;
            throw new IllegalStateException(message);
        }
    }

    protected void releaseWorker(WorkerThread worker) {
        worker.clearInterruptFlag();
        Pool pool = this.m_pool;
        if (pool != null) {
            pool.put((Poolable)((SimpleWorkerThread)worker));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

