/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.frontends;

import java.io.File;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.ExceptionUtil;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.AvalonFormatter;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.phoenix.frontends.CLISetup;
import org.apache.avalon.phoenix.frontends.ShutdownHook;
import org.apache.avalon.phoenix.interfaces.Embeddor;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.FileTarget;

public final class CLIMain
extends Observable
implements Runnable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$frontends$CLIMain == null ? (class$org$apache$avalon$phoenix$frontends$CLIMain = CLIMain.class$("org.apache.avalon.phoenix.frontends.CLIMain")) : class$org$apache$avalon$phoenix$frontends$CLIMain));
    private static final String DEFAULT_LOG_FILE = File.separator + "logs" + File.separator + "phoenix.log";
    private static final String DEFAULT_CONF_FILE = File.separator + "conf" + File.separator + "kernel.xml";
    private static final String DEFAULT_FORMAT = "%7.7{priority} %23.23{time:yyyy-MM-dd' 'HH:mm:ss.SSS} [%8.8{category}] (%{context}): %{message}\n%{throwable}";
    private Embeddor m_embeddor;
    private int m_exitCode;
    private ShutdownHook m_hook;
    private boolean m_shuttingDown;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$frontends$CLIMain;
    static /* synthetic */ Class class$java$util$Observer;

    public int main(String[] args, Map data, boolean blocking) {
        try {
            String command = "java " + this.getClass().getName() + " [options]";
            CLISetup setup = new CLISetup(command);
            if (!setup.parseCommandLineOptions(args)) {
                return 0;
            }
            System.out.println();
            System.out.println("Phoenix 4.2");
            System.out.println();
            Parameters parameters = setup.getParameters();
            String phoenixHome = System.getProperty("phoenix.home", "..");
            parameters.setParameter("phoenix.home", phoenixHome);
            if (!parameters.isParameter("phoenix.configfile")) {
                String filename = phoenixHome + DEFAULT_CONF_FILE;
                File configFile = new File(filename).getCanonicalFile();
                parameters.setParameter("phoenix.configfile", configFile.toString());
            }
            this.execute(parameters, data, blocking);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return this.m_exitCode;
    }

    private void execute(Parameters parameters, Map data, boolean blocking) {
        Observer observer;
        if (!this.startup(parameters, data)) {
            return;
        }
        boolean disableHook = parameters.getParameterAsBoolean("disable-hook", false);
        if (!disableHook) {
            this.m_hook = new ShutdownHook(this);
            Runtime.getRuntime().addShutdownHook(this.m_hook);
        }
        if (null != (observer = (Observer)data.get((class$java$util$Observer == null ? (class$java$util$Observer = CLIMain.class$("java.util.Observer")) : class$java$util$Observer).getName()))) {
            this.addObserver(observer);
        }
        if (blocking) {
            this.run();
        } else {
            Thread thread = new Thread((Runnable)this, "Phoenix-Monitor");
            thread.setDaemon(false);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block7: {
            try {
                try {
                    this.m_embeddor.execute();
                }
                catch (Throwable throwable) {
                    this.handleException(throwable);
                    Object var3_2 = null;
                    if (null != this.m_hook) {
                        Runtime.getRuntime().removeShutdownHook(this.m_hook);
                    }
                    this.shutdown();
                    return;
                }
                Object var3_1 = null;
                if (null == this.m_hook) break block7;
                Runtime.getRuntime().removeShutdownHook(this.m_hook);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (null != this.m_hook) {
                    Runtime.getRuntime().removeShutdownHook(this.m_hook);
                }
                this.shutdown();
                throw throwable;
            }
        }
        this.shutdown();
    }

    private synchronized boolean startup(Parameters parameters, Map data) {
        try {
            String configFilename = parameters.getParameter("phoenix.configfile");
            Configuration root = this.getConfigurationFor(configFilename);
            Configuration configuration = root.getChild("embeddor");
            String embeddorClassname = configuration.getAttribute("class");
            this.m_embeddor = (Embeddor)Class.forName(embeddorClassname).newInstance();
            ContainerUtil.enableLogging((Object)this.m_embeddor, (org.apache.avalon.framework.logger.Logger)this.createLogger(parameters));
            ContainerUtil.contextualize((Object)this.m_embeddor, (Context)new DefaultContext(data));
            ContainerUtil.parameterize((Object)this.m_embeddor, (Parameters)parameters);
            ContainerUtil.configure((Object)this.m_embeddor, (Configuration)configuration);
            ContainerUtil.initialize((Object)this.m_embeddor);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
            return false;
        }
        return true;
    }

    private org.apache.avalon.framework.logger.Logger createLogger(Parameters parameters) throws Exception {
        String phoenixHome = parameters.getParameter("phoenix.home");
        String logDestination = parameters.getParameter("log-destination", phoenixHome + DEFAULT_LOG_FILE);
        String logPriority = parameters.getParameter("log-priority", "INFO");
        AvalonFormatter formatter = new AvalonFormatter(DEFAULT_FORMAT);
        File file = new File(logDestination);
        FileTarget logTarget = new FileTarget(file, false, (Formatter)formatter);
        Hierarchy hierarchy = new Hierarchy();
        Logger logger = hierarchy.getLoggerFor("Phoenix");
        logger.setLogTargets(new LogTarget[]{logTarget});
        logger.setPriority(Priority.getPriorityForName((String)logPriority));
        logger.info("Logger started");
        return new LogKitLogger(logger);
    }

    protected void forceShutdown() {
        if (null == this.m_hook || null == this.m_embeddor) {
            return;
        }
        String message = REZ.getString("main.abnormal-exit.notice");
        System.out.print(message);
        System.out.print(" ");
        System.out.flush();
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (!this.m_shuttingDown) {
            this.m_shuttingDown = true;
            this.m_hook = null;
            if (null != this.m_embeddor) {
                String message = REZ.getString("main.exit.notice");
                System.out.println(message);
                System.out.flush();
                try {
                    ContainerUtil.shutdown((Object)this.m_embeddor);
                }
                catch (Throwable throwable) {
                    this.handleException(throwable);
                }
                finally {
                    this.m_embeddor = null;
                }
            }
            this.setChanged();
            this.notifyObservers("shutdown");
        }
    }

    private void handleException(Throwable throwable) {
        System.out.println(REZ.getString("main.exception.header"));
        System.out.println("---------------------------------------------------------");
        System.out.println("--- Message ---");
        System.out.println(throwable.getMessage());
        System.out.println("--- Stack Trace ---");
        System.out.println(ExceptionUtil.printStackTrace((Throwable)throwable));
        System.out.println("---------------------------------------------------------");
        System.out.println(REZ.getString("main.exception.footer"));
        this.m_exitCode = 1;
    }

    private Configuration getConfigurationFor(String location) throws Exception {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        return builder.buildFromFile(location);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

