/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.extensions.pkgmgr.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.avalon.excalibur.extension.Extension;
import org.apache.avalon.phoenix.components.extensions.pkgmgr.ExtensionManager;
import org.apache.avalon.phoenix.components.extensions.pkgmgr.OptionalPackage;
import org.apache.avalon.phoenix.components.extensions.pkgmgr.impl.OptionalPackageComparator;

public class DefaultExtensionManager
implements ExtensionManager {
    private static final boolean DEBUG = false;
    private static final String SEPARATOR = "|";
    private final Map m_packages = new HashMap();
    private File[] m_path;
    private boolean m_needToScan;

    public DefaultExtensionManager() {
        this(new File[0]);
    }

    public DefaultExtensionManager(File[] path) {
        this.setPath(path);
    }

    public File[] getPaths() {
        return this.m_path;
    }

    public synchronized OptionalPackage[] getOptionalPackages(Extension extension) {
        if (this.m_needToScan) {
            this.scanPath();
        }
        ArrayList<OptionalPackage> results = new ArrayList<OptionalPackage>();
        ArrayList candidates = (ArrayList)this.m_packages.get(extension.getExtensionName());
        if (null != candidates) {
            int size = candidates.size();
            for (int i = 0; i < size; ++i) {
                OptionalPackage optionalPackage = (OptionalPackage)candidates.get(i);
                Extension[] extensions = optionalPackage.getAvailableExtensions();
                for (int j = 0; j < extensions.length; ++j) {
                    if (!extensions[j].isCompatibleWith(extension)) continue;
                    results.add(optionalPackage);
                }
            }
        }
        OptionalPackageComparator comparator = new OptionalPackageComparator(extension.getExtensionName());
        Collections.sort(results, comparator);
        return results.toArray(new OptionalPackage[0]);
    }

    protected synchronized OptionalPackage[] getAllOptionalPackages() {
        ArrayList<OptionalPackage> packages = new ArrayList<OptionalPackage>();
        Iterator iterator = this.m_packages.values().iterator();
        while (iterator.hasNext()) {
            ArrayList list = (ArrayList)iterator.next();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                OptionalPackage optionalPackage = (OptionalPackage)list.get(i);
                if (packages.contains(optionalPackage)) continue;
                packages.add(optionalPackage);
            }
        }
        return packages.toArray(new OptionalPackage[packages.size()]);
    }

    protected void addPathElements(String[] pathElements) {
        File[] path = this.toFiles(pathElements);
        this.addPathElements(path);
    }

    protected synchronized void addPathElements(File[] path) {
        this.validatePath(path);
        File[] files = this.resolvePath(path);
        this.m_path = this.mergePaths(files);
        this.m_needToScan = true;
    }

    protected void addPathElements(String pathString) {
        String[] pathElements = DefaultExtensionManager.split(pathString, SEPARATOR);
        this.addPathElements(pathElements);
    }

    protected synchronized void setPath(String pathString) {
        String[] pathElements = DefaultExtensionManager.split(pathString, SEPARATOR);
        this.setPath(pathElements);
    }

    protected synchronized void setPath(String[] pathElements) {
        File[] path = this.toFiles(pathElements);
        this.setPath(path);
    }

    protected synchronized void setPath(File[] path) {
        this.validatePath(path);
        this.m_path = this.resolvePath(path);
        this.m_needToScan = true;
    }

    protected final synchronized void scanPath() {
        this.clearCache();
        for (int i = 0; i < this.m_path.length; ++i) {
            this.scanDirectory(this.m_path[i]);
        }
    }

    private synchronized void scanDirectory(File directory) {
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String message;
            File file = files[i];
            String name = file.getName();
            if (!name.endsWith(".jar")) {
                message = "Skipping " + file + " as it does not end with '.jar'";
                this.debug(message);
                continue;
            }
            if (!file.isFile()) {
                message = "Skipping " + file + " as it is not a file.";
                this.debug(message);
                continue;
            }
            if (!file.canRead()) {
                message = "Skipping " + file + " as it is not readable.";
                this.debug(message);
                continue;
            }
            try {
                OptionalPackage optionalPackage = this.getOptionalPackage(file);
                this.cacheOptionalPackage(optionalPackage);
                continue;
            }
            catch (IOException ioe) {
                String message2 = "Skipping " + file + " as it could not be loaded " + "due to " + ioe;
                this.debug(message2);
            }
        }
    }

    protected final synchronized void clearCache() {
        this.m_packages.clear();
        this.m_needToScan = true;
    }

    protected final synchronized void cacheOptionalPackage(OptionalPackage optionalPackage) {
        this.m_needToScan = false;
        if (optionalPackage.getAvailableExtensions().length == 0) {
            return;
        }
        Extension extension = optionalPackage.getAvailableExtensions()[0];
        ArrayList<OptionalPackage> candidates = (ArrayList<OptionalPackage>)this.m_packages.get(extension.getExtensionName());
        if (null == candidates) {
            candidates = new ArrayList<OptionalPackage>();
            this.m_packages.put(extension.getExtensionName(), candidates);
        }
        candidates.add(optionalPackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OptionalPackage getOptionalPackage(File archive) throws IOException {
        File file = archive.getCanonicalFile();
        JarFile jarFile = new JarFile(file);
        try {
            Manifest manifest = jarFile.getManifest();
            if (null == manifest) {
                OptionalPackage optionalPackage = null;
                return optionalPackage;
            }
            Extension[] available = Extension.getAvailable((Manifest)manifest);
            Extension[] required = Extension.getRequired((Manifest)manifest);
            OptionalPackage optionalPackage = new OptionalPackage(file, available, required);
            return optionalPackage;
        }
        finally {
            jarFile.close();
        }
    }

    protected void debug(String message) {
    }

    private File[] resolvePath(File[] path) {
        File[] resultPath = new File[path.length];
        for (int i = 0; i < path.length; ++i) {
            resultPath[i] = this.resolveFile(path[i]);
        }
        return resultPath;
    }

    private File resolveFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    private void validatePath(File[] path) {
        if (null == path) {
            throw new NullPointerException("path");
        }
        for (int i = 0; i < path.length; ++i) {
            this.validatePathElement(path[i]);
        }
    }

    private void validatePathElement(File file) {
        if (!file.exists() || !file.isDirectory()) {
            String message = "path element " + file + " must exist and must be a directory";
            throw new IllegalArgumentException(message);
        }
    }

    private File[] mergePaths(File[] files) {
        File[] resultPath = new File[this.m_path.length + files.length];
        System.arraycopy(this.m_path, 0, resultPath, 0, this.m_path.length);
        System.arraycopy(files, this.m_path.length, resultPath, 0, files.length);
        return resultPath;
    }

    private File[] toFiles(String[] pathElements) {
        File[] path = new File[pathElements.length];
        for (int i = 0; i < path.length; ++i) {
            path[i] = new File(pathElements[i]);
        }
        return path;
    }

    private static String[] split(String string, String onToken) {
        StringTokenizer tokenizer = new StringTokenizer(string, onToken);
        String[] result = new String[tokenizer.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = tokenizer.nextToken();
        }
        return result;
    }
}

