/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.deployer;

import java.util.ArrayList;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.components.assembler.Assembler;
import org.apache.avalon.phoenix.components.deployer.PhoenixComponentFactory;
import org.apache.avalon.phoenix.containerkit.factory.ComponentBundle;
import org.apache.avalon.phoenix.containerkit.factory.ComponentFactory;
import org.apache.avalon.phoenix.containerkit.metadata.ComponentMetaData;
import org.apache.avalon.phoenix.containerkit.metadata.PartitionMetaData;
import org.apache.avalon.phoenix.containerkit.profile.ComponentProfile;
import org.apache.avalon.phoenix.containerkit.profile.PartitionProfile;
import org.apache.avalon.phoenix.containerkit.profile.ProfileBuilder;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.tools.infobuilder.LegacyUtil;

public class PhoenixProfileBuilder
extends AbstractLogEnabled
implements ProfileBuilder {
    private final Assembler m_assembler = new Assembler();

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.setupLogger((Object)this.m_assembler);
    }

    public PartitionProfile buildProfile(Map parameters) throws Exception {
        PartitionMetaData metaData = this.m_assembler.buildAssembly(parameters);
        ClassLoader classLoader = (ClassLoader)parameters.get("phoenix:classloader");
        PhoenixComponentFactory factory = new PhoenixComponentFactory(classLoader);
        this.setupLogger((Object)factory, "factory");
        return this.assembleSarProfile(metaData, (ComponentFactory)factory);
    }

    private PartitionProfile assembleSarProfile(PartitionMetaData metaData, ComponentFactory factory) throws Exception {
        PartitionMetaData blockPartition = metaData.getPartition("block");
        PartitionMetaData listenerPartition = metaData.getPartition("listener");
        PartitionProfile blockProfile = this.assembleProfile(blockPartition, factory);
        PartitionProfile listenerProfile = this.assembleListenerProfile(listenerPartition);
        PartitionProfile[] profiles = new PartitionProfile[]{blockProfile, listenerProfile};
        return new PartitionProfile(metaData, profiles, new ComponentProfile[0]);
    }

    private PartitionProfile assembleListenerProfile(PartitionMetaData metaData) {
        ArrayList<ComponentProfile> componentSet = new ArrayList<ComponentProfile>();
        ComponentMetaData[] components = metaData.getComponents();
        for (int i = 0; i < components.length; ++i) {
            ComponentMetaData component = components[i];
            ComponentInfo info = LegacyUtil.createListenerInfo((String)component.getImplementationKey());
            ComponentProfile profile = new ComponentProfile(info, component);
            componentSet.add(profile);
        }
        ComponentProfile[] profiles = componentSet.toArray(new ComponentProfile[componentSet.size()]);
        return new PartitionProfile(metaData, PartitionProfile.EMPTY_SET, profiles);
    }

    private PartitionProfile assembleProfile(PartitionMetaData metaData, ComponentFactory factory) throws Exception {
        ArrayList<PartitionProfile> partitionSet = new ArrayList<PartitionProfile>();
        PartitionMetaData[] partitions = metaData.getPartitions();
        for (int i = 0; i < partitions.length; ++i) {
            PartitionMetaData partition = partitions[i];
            PartitionProfile profile = this.assembleProfile(partition, factory);
            partitionSet.add(profile);
        }
        ArrayList<ComponentProfile> componentSet = new ArrayList<ComponentProfile>();
        ComponentMetaData[] components = metaData.getComponents();
        for (int i = 0; i < components.length; ++i) {
            ComponentMetaData component = components[i];
            ComponentBundle bundle = factory.createBundle(component.getImplementationKey());
            ComponentInfo info = bundle.getComponentInfo();
            ComponentProfile profile = new ComponentProfile(info, component);
            componentSet.add(profile);
        }
        PartitionProfile[] partitionProfiles = partitionSet.toArray(new PartitionProfile[partitionSet.size()]);
        ComponentProfile[] componentProfiles = componentSet.toArray(new ComponentProfile[componentSet.size()]);
        return new PartitionProfile(metaData, partitionProfiles, componentProfiles);
    }
}

